/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import oracle.cluster.cmdtools.CRSCTLUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.ParamPreReqHWOSSetup;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.database.DatabaseConnectInfoException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.pluggable.xml.PluggableConfigXmlParser;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskACFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskASMDeviceChecks;
import oracle.ops.verification.framework.engine.task.TaskASMIntegrity;
import oracle.ops.verification.framework.engine.task.TaskASMLibChecks;
import oracle.ops.verification.framework.engine.task.TaskASMMissizedDiskCheck;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskAuditFileDestCheck;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSUserConsistent;
import oracle.ops.verification.framework.engine.task.TaskCRSVersionConsistency;
import oracle.ops.verification.framework.engine.task.TaskCTSSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCheckFirewallSetting;
import oracle.ops.verification.framework.engine.task.TaskCheckMediaSense;
import oracle.ops.verification.framework.engine.task.TaskChkDirStructure;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterwareConfigOutsideHome;
import oracle.ops.verification.framework.engine.task.TaskCoreFileNameConsistency;
import oracle.ops.verification.framework.engine.task.TaskCurrentGroupID;
import oracle.ops.verification.framework.engine.task.TaskCurrentUserIsDomainUser;
import oracle.ops.verification.framework.engine.task.TaskDBCRSVersionCompatibility;
import oracle.ops.verification.framework.engine.task.TaskDBUserConsistent;
import oracle.ops.verification.framework.engine.task.TaskDHCPChecks;
import oracle.ops.verification.framework.engine.task.TaskDomainSockets;
import oracle.ops.verification.framework.engine.task.TaskEZConnect;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskGNSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskHAIntegrity;
import oracle.ops.verification.framework.engine.task.TaskIPMIChecks;
import oracle.ops.verification.framework.engine.task.TaskMulticastCheck;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.engine.task.TaskNodeAddDelete;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskOCRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOLRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOSDbGroupsExistence;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.engine.task.TaskPinNodes;
import oracle.ops.verification.framework.engine.task.TaskResolvConfIntegrity;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskScan;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.engine.task.TaskStaleSchema;
import oracle.ops.verification.framework.engine.task.TaskTimeZoneSetting;
import oracle.ops.verification.framework.engine.task.TaskUSMDriverChecks;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.engine.task.TaskUpgCheckASMDiscoveryString;
import oracle.ops.verification.framework.engine.task.TaskUpgradeChecksASMAndListener;
import oracle.ops.verification.framework.engine.task.TaskUserMask;
import oracle.ops.verification.framework.engine.task.TaskUserNotInGroup;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.engine.task.TaskVIPSubnetCheck;
import oracle.ops.verification.framework.engine.task.TaskValidateNodeRoles;
import oracle.ops.verification.framework.engine.task.TaskVotingDisk;
import oracle.ops.verification.framework.engine.task.sTaskFactory;
import oracle.ops.verification.framework.engine.task.sTaskGIConfigurationFiles;
import oracle.ops.verification.framework.engine.task.sTaskNameServiceSwitch;
import oracle.ops.verification.framework.engine.task.sTaskRootConsistency;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskFactory
implements VerificationAPIConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static TaskFactory _taskFactory;
    private ParamPreReq m_param;
    private VerificationType m_vfyType;
    static boolean m_isCLImode;
    static boolean m_isAPImode;
    static boolean m_isBestPracticemode;
    static ParamManager m_pm;
    static final String FSEP;
    static final String LSEP;

    private TaskFactory() throws TaskFactoryException {
    }

    public static synchronized TaskFactory getInstance() throws TaskFactoryException {
        if (_taskFactory == null) {
            _taskFactory = new TaskFactory();
        }
        return _taskFactory;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> taskList = null;
        this.m_param = param;
        this.m_vfyType = vfyType;
        switch (vfyType) {
            case PREREQ_CRS_INST: {
                taskList = this.getTaskListPreCRSInst(nodeList);
                break;
            }
            case POSTREQ_CRS_INST: {
                taskList = this.getTaskListPostCRSInst(nodeList);
                break;
            }
            case PREREQ_DB_INST: {
                taskList = this.getTaskListPreDBInst(nodeList);
                break;
            }
            case PREREQ_DB_CONFIG: {
                taskList = this.getTaskListPreDBConfig(nodeList);
                break;
            }
            case POSTREQ_DB_CONFIG: {
                taskList = this.getTaskListPostDBConfig(nodeList);
                break;
            }
            case PREREQ_SI_HA_INST: {
                taskList = this.getTaskListPreSIHAInst(nodeList);
                break;
            }
            case PREREQ_SI_DB_INST: {
                taskList = this.getTaskListPreSIDBInst(nodeList);
                break;
            }
            case PREREQ_SI_DB_CONFIG: {
                taskList = this.getTaskListPreSIDBConfig(nodeList);
                break;
            }
            case PREREQ_SI_HA_CONFIG: {
                taskList = this.getTaskListPreHAConfig(nodeList);
                break;
            }
            case POSTREQ_SI_HA_CONFIG: {
                taskList = this.getTaskListPostHAConfig(nodeList);
                break;
            }
            case POSTREQ_HWOS_SETUP: {
                taskList = this.getTaskListPostHWOSSetup(nodeList);
                break;
            }
            case PREREQ_CFS_SETUP: {
                taskList = this.getTaskListPreCFSSetup(nodeList);
                break;
            }
            case POSTREQ_CFS_SETUP: {
                taskList = this.getTaskListPostCFSSetup(nodeList);
                break;
            }
            case PREREQ_NODE_ADD: {
                taskList = this.getTaskListPreNodeAdd(nodeList);
                break;
            }
            case PREREQ_RACNODE_ADD: {
                taskList = this.getTaskListPreRACNodeAdd(nodeList);
                break;
            }
            case POSTREQ_NODE_ADD: {
                taskList = this.getTaskListPostNodeAdd(nodeList);
                break;
            }
            case POSTREQ_NODE_DEL: {
                taskList = this.getTaskListPostNodeDel(nodeList);
                break;
            }
            case SYSREQ_CRS: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_DB: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_SI_HA: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_SI_DB: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case PREREQ_USM_CONFIG: {
                taskList = this.getTaskListPreUSMConfig(nodeList);
                break;
            }
            case POSTREQ_USM_CONFIG: {
                taskList = this.getTaskListPostUSMConfig(nodeList);
                break;
            }
            case BESTPRACTICE_PRE_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_DB_CONFIG: 
            case BESTPRACTICE_POSTREQ_SI_HA_CONFIG: {
                taskList = new ArrayList<Task>();
                break;
            }
            case PREREQ_FARM_HEALTH: {
                taskList = this.getTaskListFarmHealth(nodeList);
            }
        }
        List<Task> sosdTaskList = new sTaskFactory(this).getTaskList(vfyType, nodeList, param);
        if (sosdTaskList != null && sosdTaskList.size() > 0) {
            taskList.addAll(sosdTaskList);
        }
        List<PluggableTask> pluggableTaskList = null;
        try {
            pluggableTaskList = this.getPluggableTasks(vfyType, nodeList);
        }
        catch (XmlParserException e) {
            throw new TaskFactoryException(e);
        }
        if (pluggableTaskList != null && pluggableTaskList.size() > 0) {
            Trace.out((String)("Adding " + pluggableTaskList.size() + " pluggable tasks"));
            taskList.addAll(pluggableTaskList);
        } else {
            Trace.out((String)"No pluggable tasks are available.");
        }
        return taskList;
    }

    private List<Task> filterBestPracticeTask(List<Task> taskList) {
        ArrayList<Task> bestPracticeTaskList = new ArrayList<Task>();
        for (Task task : taskList) {
            if (task.hasSubtasks()) {
                try {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        if (!((Task)subTask).isBestPractice()) continue;
                        bestPracticeTaskList.add((Task)subTask);
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    continue;
                }
            }
            if (!task.isBestPractice()) continue;
            bestPracticeTaskList.add(task);
        }
        return bestPracticeTaskList;
    }

    public List<PluggableTask> getPluggableTasks(VerificationType vfyType, String[] nodeList) throws XmlParserException {
        List<PluggableTask> pluggableTaskList = null;
        String release = null;
        if (this.m_param != null) {
            if (this.m_param instanceof ParamPreReqDBInst) {
                release = ((ParamPreReqDBInst)this.m_param).getRelease();
            } else if (this.m_param instanceof ParamPreReqCRSInst) {
                release = ((ParamPreReqCRSInst)this.m_param).getRelease();
            } else if (this.m_param instanceof ParamPreReqDBConfig) {
                release = ((ParamPreReqDBConfig)this.m_param).getRelease();
            } else if (this.m_param instanceof ParamPreReqHAConfig) {
                // empty if block
            }
        }
        if (release == null) {
            release = "12.1";
        }
        pluggableTaskList = new PluggableConfigXmlParser().getTasks(release, VerificationUtil.getUniqueDistributionID(), vfyType.getID(), nodeList);
        return pluggableTaskList;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> taskList = this.getTaskList(vfyType, nodeList, param);
        for (Task task : taskList) {
            if (task.hasSubtasks()) {
                try {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        ((Task)subTask).setMultiTaskHandler(multiTaskHandler);
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    throw new TaskFactoryException(e);
                }
            }
            task.setMultiTaskHandler(multiTaskHandler);
        }
        return taskList;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, (ParamPreReq)null);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, null, multiTaskHandler);
    }

    private List<Task> getTaskListPreCRSInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String[] pathArr;
        TaskASMIntegrity taskASMInteg;
        String reqRel;
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCRSInst param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnixSystem = nativeSystem.isUnixSystem();
        boolean isSoftwareOnlyInstall = VerificationUtil.isCRSSoftwareOnlyInstall();
        boolean isCRSConfigured = VerificationUtil.isCRSConfigured();
        String[] votLocArr = null;
        String localNode = VerificationUtil.getLocalHostName();
        boolean isGNSConfigured = false;
        boolean isDHCPConfigured = false;
        boolean isVIPdhcpAssigned = false;
        boolean isVerPost12c = false;
        String actCRSVer = null;
        String crsHome = VerificationUtil.getVariableValue("ORACLE_HOME");
        boolean isRolling = false;
        boolean localNodeCRSRunning = this.isLocalNodeCRSRunning();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqCRSInst)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7511", false));
            }
            param = (ParamPreReqCRSInst)this.m_param;
        } else {
            String ocrLocStr = VerificationUtil.getVariableValue("OCR_LOCATIONS");
            if (ocrLocStr != null) {
                String[] ocrLocArr = VerificationUtil.string2strArr(ocrLocStr);
                if (ocrLocArr == null || ocrLocArr.length == 0) {
                    throw new TaskFactoryException(s_msgBundle.getMessage("5461", true, (Object[])new String[]{"OCR_LOCATIONS"}));
                }
                param = new ParamPreReqCRSInst();
                param.setOCRLoc(ocrLocArr);
                Trace.out((String)"Added ocr locations to ParamPreReqCRSInst");
            }
            String votLocStr = null;
            if (param != null && param.getVotingLoc() != null) {
                votLocArr = param.getVotingLoc();
            }
            if (votLocArr == null) {
                votLocStr = VerificationUtil.getVariableValue("VOTING_LOCATIONS");
            }
            if (votLocStr != null) {
                votLocArr = VerificationUtil.string2strArr(votLocStr);
                if (votLocArr == null || votLocArr.length == 0) {
                    throw new TaskFactoryException(s_msgBundle.getMessage("5461", true, (Object[])new String[]{"VOTING_LOCATIONS"}));
                }
            } else if (votLocArr != null) {
                if (param == null) {
                    param = new ParamPreReqCRSInst();
                }
                param.setVotingLoc(votLocArr);
                Trace.out((String)"Added voting disk locations to ParamPreReqCRSInst");
            }
        }
        String installOption = VerificationUtil.getVariableValue("INSTALL_OPTION");
        boolean isUpgrade = "UPGRADE".equalsIgnoreCase(installOption);
        if (isUpgrade) {
            actCRSVer = VerificationUtil.getCRSActiveVersion();
        }
        Trace.out((String)("actCRSVer=" + actCRSVer));
        if ("true".equalsIgnoreCase(VerificationUtil.getVariableValue("ISROLLING"))) {
            isRolling = true;
        }
        String string = reqRel = param != null ? param.getRelease() : null;
        if (reqRel == null) {
            reqRel = "12.1";
        }
        if (isUpgrade) {
            if (!VerificationUtil.isStringGood(crsHome)) {
                crsHome = VerificationUtil.getCRSHome();
            }
            if (!VerificationUtil.isStringGood(localNode)) {
                localNode = VerificationUtil.getLocalHostName();
            }
            if (isUnixSystem) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"UPGRADE Case - Found existing old version of CRS installation, Adding CRS User consistency check.");
                }
                TaskCRSUserConsistent taskCRSUserCon = new TaskCRSUserConsistent(nodeList);
                taskCRSUserCon.setSIHA(false);
                taskList.add(taskCRSUserCon);
            }
            this.addASMUpgradeChecks(taskList, nodeList, false);
            Version curVer = VerificationUtil.getCRSActiveVersionObj();
            if (curVer != null && Version.isPre112((Version)curVer)) {
                Trace.out((String)"Found an upgrade from pre 11.2 scenario, Adding ASM instance and default listener check");
                taskList.add(new TaskUpgradeChecksASMAndListener(curVer, nodeList));
            } else {
                Trace.out((String)"The source home version is not pre 11.2 and hence not adding ASM instance and default listener check");
            }
        }
        this.addNodeConnectivityChecks(nodeList, taskList, isRolling, localNodeCRSRunning, localNode, installOption, reqRel);
        String oraBase = VerificationUtil.getVariableValue("ORACLE_BASE");
        if (isUnixSystem && oraBase != null && crsHome != null) {
            TaskChkDirStructure tds = new TaskChkDirStructure(nodeList, VerificationType.PREREQ_CRS_INST);
            taskList.add(tds);
        }
        if (!isUnixSystem) {
            TaskCheckFirewallSetting taskFirewall = new TaskCheckFirewallSetting(nodeList);
            taskList.add(taskFirewall);
        }
        if (this.addASMRunningChecks(nodeList, taskASMInteg = new TaskASMIntegrity(nodeList), param, isUpgrade, isRolling, reqRel)) {
            if (isUpgrade) {
                taskASMInteg.setUpgradeMode(true);
                taskASMInteg.setNodeList(new String[]{localNode});
            }
            taskList.add(taskASMInteg);
        }
        this.addOCRIntegrityChecks(nodeList, taskList, param, isUpgrade, isRolling, reqRel);
        TaskSharedStorageAccess taskSSAccessVdisk = null;
        if (param != null && (pathArr = param.getVotingLoc()) != null) {
            for (String path : pathArr) {
                if (VerificationUtil.getCurrentOS().toLowerCase().startsWith("windows")) {
                    Vector<String> succNodes = new Vector<String>();
                    Vector<String> failNodes = new Vector<String>();
                    String drvPath = path.substring(0, path.indexOf(FSEP) + 1);
                    boolean pExist = VerificationUtil.pathExists(nodeList, drvPath, 0, succNodes, failNodes);
                    if (succNodes.size() == 0) continue;
                }
                taskSSAccessVdisk = new TaskSharedStorageAccess(nodeList);
                taskSSAccessVdisk.setStorageIDlist(new String[]{path});
                taskSSAccessVdisk.setCheckWritableFS(false);
                taskSSAccessVdisk.setVDiskLocationFlag(true);
                taskList.add(taskSSAccessVdisk);
            }
        }
        if (VerificationUtil.isPlatformLinux()) {
            TaskASMLibChecks taskASMLib = new TaskASMLibChecks(nodeList);
            taskList.add(taskASMLib);
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_CRS_INST);
        taskList.addAll(sysReqTaskList);
        this.crsCVUQDiskPackageCheck(nodeList, taskList, param, isUpgrade, isRolling);
        this.addASMDeviceChecks(nodeList, taskList, param, nativeSystem, reqRel);
        TaskNTP taskNTP = new TaskNTP(nodeList);
        if (reqRel == null || VerificationUtil.isVersionPost(reqRel, "11.2")) {
            taskNTP.setPreCheck(true);
        }
        taskNTP.setRequestedRelease(reqRel);
        taskList.add(taskNTP);
        if (isUnixSystem) {
            TaskCoreFileNameConsistency taskCore = new TaskCoreFileNameConsistency(nodeList);
            taskList.add(taskCore);
            TaskUserNotInGroup taskRoot = new TaskUserNotInGroup(nodeList, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskRoot);
            if (!VerificationUtil.isCVUTestEnv()) {
                TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
                taskList.add(taskUM);
            }
            TaskResolvConfIntegrity taskResolvConf = new TaskResolvConfIntegrity(nodeList);
            taskList.add(taskResolvConf);
            TaskUSMUdevChecks taskOCRUdev = null;
            TaskUSMUdevChecks taskVDiskUdev = null;
            if (VerificationUtil.isUDEVSupported() && isUpgrade) {
                taskOCRUdev = new TaskUSMUdevChecks(nodeList);
                taskOCRUdev.setOCRUDevCheck();
                taskList.add(taskOCRUdev);
                if (isRolling) {
                    taskVDiskUdev = new TaskUSMUdevChecks(nodeList);
                    taskVDiskUdev.setVDiskUDevCheck();
                    taskList.add(taskVDiskUdev);
                }
            }
        } else {
            TaskCurrentUserIsDomainUser taskCurrentUser = new TaskCurrentUserIsDomainUser(nodeList);
            taskList.add(taskCurrentUser);
        }
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
        taskTZ.setTaskType(0);
        taskList.add(taskTZ);
        String gnsConfig = VerificationUtil.getVariableValue("CONFIGURE_GNS");
        isGNSConfigured = gnsConfig != null && gnsConfig.equalsIgnoreCase("true");
        String dhcpConfig = VerificationUtil.getVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP");
        boolean bl = isDHCPConfigured = dhcpConfig != null && dhcpConfig.equalsIgnoreCase("true");
        if (isGNSConfigured) {
            TaskGNSIntegrity taskGNS = new TaskGNSIntegrity(nodeList);
            taskGNS.setPreCheck(true);
            taskList.add(taskGNS);
        }
        isVIPdhcpAssigned = isVerPost12c ? isDHCPConfigured : isGNSConfigured;
        Trace.out((String)("isGNSConfigured=" + isGNSConfigured + "; isDHCPConfigured=" + isDHCPConfigured + "; isVIPdhcpAssigned=" + isVIPdhcpAssigned));
        if (!isVIPdhcpAssigned) {
            TaskVIPSubnetCheck taskVIPSubnetCheck = new TaskVIPSubnetCheck(nodeList);
            Trace.out((String)("isUpgrade = " + isUpgrade + ", isRolling  = " + isRolling));
            if (isUpgrade) {
                if (isRolling) {
                    taskVIPSubnetCheck.setIsPreCRS(false);
                    taskList.add(taskVIPSubnetCheck);
                }
            } else if (VerificationUtil.getVariableValue("INTERCONNECT_LIST") != null && VerificationUtil.getVariableValue("HOST_VIP_NAMES") != null) {
                taskVIPSubnetCheck.setIsPreCRS(true);
                taskList.add(taskVIPSubnetCheck);
            }
        }
        this.addVotingDiskChecks(nodeList, taskList, votLocArr, isRolling, isUpgrade, reqRel);
        String ipmiConfig = VerificationUtil.getVariableValue("USE_IPMI");
        if (ipmiConfig != null && ipmiConfig.equalsIgnoreCase("true")) {
            TaskIPMIChecks taskIPMI = new TaskIPMIChecks(nodeList);
            taskIPMI.setIsPreCRS(true);
            taskList.add(taskIPMI);
        }
        if (isUpgrade) {
            TaskCRSVersionConsistency taskCRSVerConsis = new TaskCRSVersionConsistency(nodeList);
            taskCRSVerConsis.setConsistenyMandatory(true);
            taskCRSVerConsis.setNonRollingUpgrade(!isRolling);
            taskCRSVerConsis.setVerificationType(this.m_vfyType);
            taskList.add(taskCRSVerConsis);
            Trace.out((String)"Added TaskCRSVersionConsistency");
        }
        if (isUnixSystem && isUpgrade && actCRSVer != null && VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
            Trace.out((String)"Attempt to get ASM home");
            Result result = new Result(localNode);
            String asmHome = CVUHelperUtil.getASMhome(result);
            if (asmHome != null) {
                String asmOSDBAgrp = null;
                try {
                    asmOSDBAgrp = nativeSystem.getOracleGroup(asmHome);
                }
                catch (NativeException e) {
                    Trace.out((String)("ERROR: Problem in getting OSDBA group from ASM Home: '" + asmHome + "'"));
                    Trace.out((Exception)((Object)e));
                    String errorMsg = s_msgBundle.getMessage("4013", true, (Object[])new String[]{asmHome}) + LSEP + e.getMessage();
                    throw new TaskFactoryException(errorMsg);
                }
                Trace.out((String)("asmOSDBAgrp = " + asmOSDBAgrp));
                TaskGroupMembership grpMemTask = new TaskGroupMembership(VerificationUtil.getDefaultCRSUser(), asmOSDBAgrp);
                grpMemTask.setNodeList(nodeList);
                taskList.add(grpMemTask);
                Trace.out((String)("Added TaskGroupMembership:: User: " + VerificationUtil.getDefaultCRSUser() + " ; Group: " + asmOSDBAgrp));
            }
        }
        if (isUnixSystem) {
            sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(nodeList);
            taskList.add(taskNSS);
        }
        if (VerificationUtil.getVariableValue("INTERCONNECT_LIST") != null && VerificationUtil.getVariableValue("SCAN_NAME") != null && "FALSE".equalsIgnoreCase(VerificationUtil.getVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP"))) {
            TaskScan taskScan = new TaskScan(nodeList);
            taskScan.setIsPreCRS(true);
            taskList.add(taskScan);
        }
        if (!isUpgrade && "TRUE".equalsIgnoreCase(VerificationUtil.getVariableValue("AUTO_CONFIGURE_CLUSTER_NODE_VIP"))) {
            boolean isAddDHCPChecks = true;
            if (isUnixSystem && !RootAutomationUtility.isRootExecutionConfigured()) {
                String portStr = VerificationUtil.getVariableValue("DHCP_PORT");
                if (portStr != null) {
                    int port = Integer.parseInt(portStr);
                    if (port < 1024) {
                        isAddDHCPChecks = false;
                    }
                } else {
                    isAddDHCPChecks = false;
                }
            }
            if (isAddDHCPChecks) {
                TaskDHCPChecks taskDHCP = new TaskDHCPChecks(nodeList);
                taskDHCP.setPreCheck(true);
                taskList.add(taskDHCP);
            }
        }
        Trace.out((String)("isUpgrade=" + isUpgrade + "; isCRSConfigured=" + isCRSConfigured + "; isSoftwareOnlyInstall=" + isSoftwareOnlyInstall));
        if (isUnixSystem && m_isAPImode && !isUpgrade && !isCRSConfigured && !isSoftwareOnlyInstall) {
            Trace.out((String)"Added TaskDomainSockets");
            TaskDomainSockets taskDomainSockets = new TaskDomainSockets();
            taskDomainSockets.setNodeList(nodeList);
            taskDomainSockets.setCheckFileAbsence(true);
            taskDomainSockets.setSeverity(SeverityType.IGNORABLE);
            taskList.add(taskDomainSockets);
        }
        return taskList;
    }

    private boolean isLocalNodeCRSRunning() {
        boolean localNodeCRSRunning = false;
        String installedCRSHome = VerificationUtil.getVariableValue("oracle_install_crs_configuredCRSHome");
        if (!VerificationUtil.isStringGood(installedCRSHome)) {
            installedCRSHome = VerificationUtil.getVariableValue("ORACLE_HOME");
        }
        if (!VerificationUtil.isStringGood(installedCRSHome)) {
            installedCRSHome = VerificationUtil.getCRSHome(true);
        }
        try {
            String localNode = VerificationUtil.getLocalHost();
            if (installedCRSHome != null) {
                Version installedVersion = VerificationUtil.getCRSActiveVersionObj();
                localNodeCRSRunning = new ClusterwareInfo().isCRSRunning(installedCRSHome, localNode, installedVersion);
            } else {
                localNodeCRSRunning = false;
            }
        }
        catch (UnknownHostException e) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + e.getMessage()));
        }
        catch (InstallException ie) {
            Trace.out((String)("INSTALLEXCEPTION: \n" + ie.getMessage()));
        }
        return localNodeCRSRunning;
    }

    private void addNodeConnectivityChecks(String[] nodeList, List<Task> taskList, boolean isRolling, boolean localNodeCRSRunning, String localNode, String installOption, String reqRel) throws TaskFactoryException {
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
        taskNodeCon.setTaskType(0);
        if (installOption != null) {
            if (installOption.equalsIgnoreCase("CRS_CONFIG")) {
                this.getNetIfFromVar(taskNodeCon, taskMulticast, taskASMIntegrity);
                taskList.add(taskNodeCon);
                this.addTask(taskList, taskMulticast);
            } else if (installOption.equalsIgnoreCase("UPGRADE") && isRolling) {
                if (localNode != null && localNodeCRSRunning) {
                    Trace.out((String)"Submitting node connectivity, local CRS stack up.");
                    this.getNetIfFromOifcfg(taskNodeCon, taskMulticast, taskASMIntegrity);
                    taskList.add(taskNodeCon);
                    this.addTask(taskList, taskMulticast);
                } else {
                    Trace.out((String)"NOT submitting node connectivity, local CRS stack DOWN.");
                }
            }
        } else {
            if (VerificationUtil.isCRSConfigured() && !m_pm.hasArgument(Argument.ARG_NETWORKLIST)) {
                this.getNetIfFromOifcfg(taskNodeCon, taskMulticast, taskASMIntegrity);
            } else {
                this.getNetIfFromPMArg(nodeList[0], taskNodeCon, taskMulticast, taskASMIntegrity);
            }
            taskList.add(taskNodeCon);
            this.addTask(taskList, taskMulticast);
            if (this.isASMIntegrityRequired(taskASMIntegrity, false, reqRel)) {
                taskASMIntegrity.setPreCheck(true);
                taskList.add(taskASMIntegrity);
            }
        }
    }

    private void addVotingDiskChecks(String[] nodeList, List<Task> taskList, String[] votLocArr, boolean isRolling, boolean isUpgrade, String reqRel) {
        if (votLocArr != null) {
            TaskVotingDisk taskVoteDsk = new TaskVotingDisk(nodeList);
            taskVoteDsk.setPreReq(true);
            taskVoteDsk.setisRolling(isRolling);
            taskVoteDsk.setDiskPaths(votLocArr);
            taskList.add(taskVoteDsk);
        } else if (isUpgrade && isRolling) {
            Trace.out((String)"This is a Rolling  Upgrade Case and hence adding the Voting Disks (post) check");
            TaskVotingDisk taskVoteDsk = new TaskVotingDisk(nodeList);
            taskVoteDsk.setisRolling(isRolling);
            taskVoteDsk.setisUpgrade(true);
            taskVoteDsk.setDestinationVersion(reqRel);
            taskList.add(taskVoteDsk);
        }
    }

    private void crsCVUQDiskPackageCheck(String[] nodeList, List<Task> taskList, ParamPreReqCRSInst param, boolean isUpgrade, boolean isRolling) {
        if (!VerificationUtil.isPlatformLinux()) {
            return;
        }
        boolean cvuqdiskRequired = false;
        try {
            if (param != null && param.getASMCheck() || VerificationUtil.getVariableValue("ASM_DISKGROUP_DISKS") != null || VerificationUtil.getVariableValue("ASM_DISK_DISCOVERY_STRING") != null) {
                cvuqdiskRequired = true;
            }
            if (!cvuqdiskRequired) {
                String[] ocrLocations = null;
                if (param != null && param.getOCRLoc() != null) {
                    ocrLocations = param.getOCRLoc();
                } else if (isUpgrade && VerificationUtil.isCRSConfigured()) {
                    ResultSet resultSet = new ResultSet();
                    ocrLocations = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
                }
                if (ocrLocations != null) {
                    cvuqdiskRequired = this.isAnyRaw(ocrLocations);
                }
            }
            if (!cvuqdiskRequired) {
                String[] votLocArr = null;
                if (param != null && param.getVotingLoc() != null) {
                    votLocArr = param.getVotingLoc();
                }
                String votLocStr = null;
                if (votLocArr == null) {
                    votLocStr = VerificationUtil.getVariableValue("VOTING_LOCATIONS");
                }
                if (votLocStr != null) {
                    votLocArr = VerificationUtil.string2strArr(votLocStr);
                }
                if (isUpgrade && VerificationUtil.isCRSConfigured() && isRolling) {
                    String localHost = VerificationUtil.getLocalHost();
                    Result result = new Result(localHost);
                    Version verCRSActive = VerificationUtil.getCRSActiveVersionObj();
                    ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(localHost, result), verCRSActive);
                    VoteDiskInfo[] voteDisks = ci.getVoteDiskLocations();
                    ArrayList<String> voteDiskList = new ArrayList<String>();
                    for (VoteDiskInfo voteDiskInfo : voteDisks) {
                        voteDiskList.add(voteDiskInfo.getPath());
                    }
                    votLocArr = voteDiskList.toArray(new String[0]);
                }
                if (votLocArr != null) {
                    cvuqdiskRequired = this.isAnyRaw(votLocArr);
                }
            }
            if (cvuqdiskRequired) {
                TaskPackage taskPkgCvuqdisk = new TaskPackage("cvuqdisk", "1.0.9-1", null);
                taskPkgCvuqdisk.setNodeList(nodeList);
                taskPkgCvuqdisk.setSeverity(SeverityType.IGNORABLE);
                taskList.add(taskPkgCvuqdisk);
            }
        }
        catch (UnknownHostException e) {
            Trace.out((Exception)e);
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (NoSuchExecutableException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (ClusterInfoException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
        }
    }

    private void addCVUQDiskPackageCheck(String[] nodeList, List<Task> taskList) {
        if (!VerificationUtil.isPlatformLinux()) {
            return;
        }
        boolean cvuqdiskRequired = false;
        try {
            Version actCRSVerObj = VerificationUtil.getCRSActiveVersionObj();
            ResultSet resultSet = new ResultSet();
            String[] ocrLocations = VerificationUtil.getOCRLocations(actCRSVerObj, resultSet);
            if (ocrLocations != null && ocrLocations.length > 0) {
                cvuqdiskRequired = this.isAnyRaw(ocrLocations);
            }
            if (!cvuqdiskRequired) {
                String[] votLocArr = null;
                String localHost = VerificationUtil.getLocalHost();
                Result result = new Result(localHost);
                Version verCRSActive = VerificationUtil.getCRSActiveVersionObj();
                ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(localHost, result), verCRSActive);
                VoteDiskInfo[] voteDisks = ci.getVoteDiskLocations();
                ArrayList<String> voteDiskList = new ArrayList<String>();
                for (VoteDiskInfo voteDiskInfo : voteDisks) {
                    voteDiskList.add(voteDiskInfo.getPath());
                }
                votLocArr = voteDiskList.toArray(new String[0]);
                if (votLocArr != null) {
                    cvuqdiskRequired = this.isAnyRaw(votLocArr);
                }
            }
            if (cvuqdiskRequired) {
                TaskPackage taskPkgCvuqdisk = new TaskPackage("cvuqdisk", "1.0.9-1", null);
                taskPkgCvuqdisk.setNodeList(nodeList);
                taskPkgCvuqdisk.setSeverity(SeverityType.IGNORABLE);
                taskList.add(taskPkgCvuqdisk);
            }
        }
        catch (UnknownHostException e) {
            Trace.out((Exception)e);
        }
        catch (NoSuchCRSHomeException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (NoSuchExecutableException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (ClusterInfoException e) {
            Trace.out((Exception)((Object)e));
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
        }
    }

    private boolean isAnyRaw(String[] locations) throws StorageException {
        for (String location : locations) {
            StorageInfo sInfo;
            if (VerificationUtil.isASMPath(location) || (sInfo = new TypeFinder().getStorageInstance(location)).getType() != 1) continue;
            return true;
        }
        return false;
    }

    private void addASMDeviceChecks(String[] nodeList, List<Task> taskList, ParamPreReqCRSInst param, NativeSystem nativeSystem, String reqRel) {
        if (!nativeSystem.isUnixSystem()) {
            return;
        }
        TaskASMDeviceChecks taskASMDevChecks = null;
        String[] devarr = null;
        String asmDeviceString = VerificationUtil.getVariableValue("ASM_DISKGROUP_DISKS");
        String asmDiscoveryString = VerificationUtil.getVariableValue("ASM_DISK_DISCOVERY_STRING");
        Trace.out((int)5, (String)"ASM_DISKGROUP_DISKS=%s, ASM_DISK_DISCOVERY_STRING=%s", (Object[])new Object[]{asmDeviceString, asmDiscoveryString});
        String string = asmDeviceString = asmDeviceString != null ? asmDeviceString : asmDiscoveryString;
        if (asmDeviceString != null) {
            devarr = asmDeviceString.split(",");
        } else if (param != null && param.getASMCheck()) {
            devarr = param.getASMDevice();
        }
        if (devarr != null || param != null && param.getASMCheck()) {
            taskASMDevChecks = new TaskASMDeviceChecks(nodeList);
            taskASMDevChecks.setSeverity(SeverityType.IGNORABLE);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Device string = " + VerificationUtil.strArr2List(devarr)));
            }
            taskASMDevChecks.setDeviceString(devarr);
            String referenceGroup = VerificationUtil.getVariableValue("ASM_GROUP");
            if (referenceGroup == null) {
                referenceGroup = param != null && param.getASMADMINgroup() != null ? param.getASMADMINgroup() : VDMUtil.getDefaultAsmGroup();
            }
            taskASMDevChecks.setReferenceOwner(VerificationUtil.getDefaultCRSUser());
            taskASMDevChecks.setReferenceGroup(referenceGroup);
            taskASMDevChecks.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
            if (reqRel != null) {
                taskASMDevChecks.setVersion(reqRel);
            }
            taskList.add(taskASMDevChecks);
        }
    }

    private void addOCRIntegrityChecks(String[] nodeList, List<Task> taskList, ParamPreReqCRSInst param, boolean isUpgrade, boolean isRolling, String reqRel) {
        TaskOCRIntegrity ocrIntgr = null;
        if (param != null && param.getOCRLoc() != null) {
            ocrIntgr = new TaskOCRIntegrity(nodeList);
            ocrIntgr.setPreReq(true);
            ocrIntgr.setOcrLocArr(param.getOCRLoc());
            ocrIntgr.setUpgrade(isUpgrade);
            ocrIntgr.setDestinationVersion(reqRel);
            taskList.add(ocrIntgr);
        } else if (isUpgrade && VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"This is an Upgrade Case and hence adding the OCR Location and size check");
            ResultSet resultSet = new ResultSet();
            String[] ocrLocations = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
            if (ocrLocations != null) {
                ocrIntgr = new TaskOCRIntegrity(nodeList);
                ocrIntgr.setOcrLocArr(ocrLocations);
                ocrIntgr.setPreReq(true);
                ocrIntgr.setUpgrade(isUpgrade);
                ocrIntgr.setDestinationVersion(reqRel);
                taskList.add(ocrIntgr);
            }
        }
    }

    private boolean addASMRunningChecks(String[] nodeList, TaskASMIntegrity taskASMIntg, ParamPreReqCRSInst param, boolean isUpgrade, boolean isRolling, String reqRel) {
        if (isUpgrade && !isRolling) {
            return false;
        }
        String[] ocrLocations = null;
        String[] voteDiskLocations = null;
        ArrayList<String> ocrVdiskLocationList = new ArrayList<String>();
        if (param != null && param.getOCRLoc() != null) {
            ocrLocations = param.getOCRLoc();
        } else if (isUpgrade && VerificationUtil.isCRSConfigured()) {
            ResultSet resultSet = new ResultSet();
            ocrLocations = VerificationUtil.getOCRLocations(VerificationUtil.getCRSActiveVersionObj(), resultSet);
        }
        if (ocrLocations != null) {
            ocrVdiskLocationList.addAll(Arrays.asList(ocrLocations));
        }
        if (param != null && param.getVotingLoc() != null) {
            voteDiskLocations = param.getVotingLoc();
        } else if (isUpgrade && VerificationUtil.isCRSConfigured()) {
            try {
                VoteDiskInfo[] voteDiskLocations2;
                ArrayList<String> voteDiskLocationList = new ArrayList<String>();
                ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome(), VerificationUtil.getCRSActiveVersionObj());
                for (VoteDiskInfo vdiskInfo : voteDiskLocations2 = ci.getVoteDiskLocations()) {
                    voteDiskLocationList.add(vdiskInfo.getPath());
                }
                voteDiskLocations = voteDiskLocationList.toArray(new String[0]);
            }
            catch (ClusterInfoException e) {
                Trace.out((int)5, (String)"IGNORED: %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
            }
        }
        if (voteDiskLocations != null) {
            ocrVdiskLocationList.addAll(Arrays.asList(voteDiskLocations));
        }
        if (ocrVdiskLocationList.size() == 0) {
            return false;
        }
        boolean usesASM = false;
        for (String ocrVdiskLoc : ocrVdiskLocationList) {
            if (!VerificationUtil.isASMPath(ocrVdiskLoc)) continue;
            usesASM = true;
            taskASMIntg.setOCRonASM(usesASM);
            break;
        }
        return usesASM;
    }

    private List<Task> getTaskListPreDBInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqDBInst param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBInst)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7512", false));
            }
            param = (ParamPreReqDBInst)this.m_param;
        } else {
            param = new ParamPreReqDBInst();
        }
        String installOption = VerificationUtil.getVariableValue("INSTALL_OPTION");
        boolean isUpgrade = "UPGRADE".equalsIgnoreCase(installOption);
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        TaskASMIntegrity taskASMIntg = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeCon, taskMulticast, taskASMIntg);
        taskList.add(taskNodeCon);
        this.addTask(taskList, taskMulticast);
        TaskCFSIntegrity taskCFSIntg = null;
        if (param != null && param.orclHomeOnOCFS()) {
            taskCFSIntg = new TaskCFSIntegrity(nodeList, param.getOrclHome());
        }
        String asmAdminGroup = this.getOSDBAForASMGroup(actCRSVer, nativeSystem);
        param.setASMAdminGroup(asmAdminGroup);
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_DB_INST);
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        taskCRSIntg.setVersionConsistencyMandatory(true);
        taskCRSIntg.setVerificationType(this.m_vfyType);
        TaskClusterMgrIntegrity taskCluMgrIntg = new TaskClusterMgrIntegrity(nodeList);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(nodeList);
        TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
        taskList.addAll(sysReqTaskList);
        if (nativeSystem.isUnixSystem() && !VerificationUtil.isCVUTestEnv()) {
            taskList.add(taskUM);
        }
        if (param != null && param.orclHomeOnOCFS()) {
            taskList.add(taskCFSIntg);
        }
        taskList.add(taskCRSIntg);
        taskList.add(taskCluMgrIntg);
        String reqRel = param.getRelease();
        if (reqRel == null) {
            reqRel = "12.1";
        }
        if (!"10gR1".equalsIgnoreCase(reqRel) && !"10.1".equalsIgnoreCase(reqRel)) {
            Trace.out((String)"==== Nodeapp check added for pre dbinst check");
            taskList.add(taskNodeApp);
        }
        Trace.out((int)5, (String)"Now attempting USM Integrity...");
        if (param != null && (param.getASMCheck() || param.getUSMCheck())) {
            Trace.out((int)5, (String)"Condition for USM Integrity check satisfied.");
            String[] dgList = param.getASMDGList();
            if (dgList != null) {
                Trace.out((int)5, (String)"Adding USM Integrity task to task list");
                taskASMIntg.setVerificationType(VerificationType.PREREQ_DB_INST);
                taskASMIntg.setASMDGList(dgList);
                taskList.add(taskASMIntg);
            }
        }
        if (reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10.1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("10.2") || reqRel.equalsIgnoreCase("11gR1") || reqRel.equalsIgnoreCase("11.1"))) {
            if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
                TaskPinNodes taskPN = new TaskPinNodes(nodeList);
                taskList.add(taskPN);
            }
            if (nativeSystem.isUnixSystem()) {
                TaskCoreFileNameConsistency taskCore = new TaskCoreFileNameConsistency(nodeList);
                taskList.add(taskCore);
            }
        }
        if (actCRSVer != null && VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
            TaskNTP taskNTP = new TaskNTP(nodeList);
            taskList.add(taskNTP);
        } else if (actCRSVer != null && VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
            taskList.add(taskCTSS);
        }
        if (nativeSystem.isUnixSystem()) {
            TaskResolvConfIntegrity taskResolvConf = new TaskResolvConfIntegrity(nodeList);
            taskList.add(taskResolvConf);
        }
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
            taskTZ.setTaskType(1);
            taskList.add(taskTZ);
            TaskScan taskScan = new TaskScan(nodeList);
            taskList.add(taskScan);
            TaskGNSIntegrity taskGNS = this.checkGNSConfiguration(nodeList);
            if (taskGNS != null) {
                taskList.add(taskGNS);
            }
        }
        TaskVIPSubnetCheck taskVIPSubnetCheck = new TaskVIPSubnetCheck(nodeList);
        taskList.add(taskVIPSubnetCheck);
        String dbFileLoc = VerificationUtil.getVariableValue("DB_FILE_LOCATION");
        if (dbFileLoc != null && dbFileLoc.length() > 0) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
            taskSSAccess.setStorageIDlist(new String[]{dbFileLoc});
            taskSSAccess.setOracleFileType(OracleFileType.RAC_DATA_FILES);
            taskList.add(taskSSAccess);
        }
        if (isUpgrade) {
            try {
                Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
                Collection<DatabaseConnectInfo> dbConInfos = DatabaseConnectInfo.getDatabaseConnectInfos();
                taskList.add(new TaskStaleSchema(crsVersion, dbConInfos));
            }
            catch (DatabaseConnectInfoException exDC) {
                Trace.out((String)("DatabaseConnectInfoException occured while getting databases conect info. message " + exDC.getMessage()));
                Trace.out((String)"Skipping database upgrade checks.");
            }
        }
        if (actCRSVer != null) {
            String requiredDBVersion = VerificationUtil.getVariableValue("DEST_VERSION");
            if (requiredDBVersion == null) {
                requiredDBVersion = "10gR1".equalsIgnoreCase(reqRel) || "10.1".equalsIgnoreCase(reqRel) ? "10.1" : ("10gR2".equalsIgnoreCase(reqRel) || "10.2".equalsIgnoreCase(reqRel) ? "10.2" : ("11gR1".equalsIgnoreCase(reqRel) || "11.1".equalsIgnoreCase(reqRel) ? "11.1" : ("11gR2".equalsIgnoreCase(reqRel) || "11.2".equalsIgnoreCase(reqRel) ? "11.2" : reqRel)));
            }
            if (requiredDBVersion == null) {
                requiredDBVersion = new Version().toString();
            }
            TaskDBCRSVersionCompatibility taskDBCRSVerComp = new TaskDBCRSVersionCompatibility(nodeList, requiredDBVersion);
            taskList.add(taskDBCRSVerComp);
        }
        if (nativeSystem.isUnixSystem() && isUpgrade) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"UPGRADE Case - Found existing old version of DB installation, Adding DB User consistency check.");
            }
            TaskDBUserConsistent taskDBUserCon = new TaskDBUserConsistent(nodeList);
            String srcDBHome = VerificationUtil.getVariableValue("SRC_RAC_HOME");
            taskDBUserCon.setDBHome(srcDBHome);
            taskList.add(taskDBUserCon);
        }
        this.addGroupChecks(taskList, null, nodeList, true);
        return taskList;
    }

    private String getOSDBAForASMGroup(String actCRSVer, NativeSystem nativeSystem) {
        String asmAdminGroup = null;
        if (!nativeSystem.isUnixSystem()) {
            return null;
        }
        if (actCRSVer != null && VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
            Trace.out((String)"Attempt to get ASM home");
            Result result = new Result(VerificationUtil.getLocalHostName());
            String asmHome = CVUHelperUtil.getASMhome(result);
            if (asmHome != null) {
                try {
                    asmAdminGroup = nativeSystem.getOracleGroup(asmHome);
                }
                catch (NativeException e) {
                    Trace.out((String)("ERROR: Problem in getting OSDBA group from ASM Home: '" + asmHome + "'"));
                    Trace.out((Exception)((Object)e));
                    return null;
                }
            }
        } else if (actCRSVer != null && VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            try {
                String home = null;
                if (VerificationUtil.isHAConfigured()) {
                    home = VerificationUtil.getHAHome();
                } else {
                    String localNode = VerificationUtil.getLocalHostName();
                    Result crsHomeResult = new Result(localNode);
                    home = VerificationUtil.getCRSHome(localNode, crsHomeResult);
                }
                if (VerificationUtil.isStringGood(home)) {
                    asmAdminGroup = VerificationUtil.getASMDBAGroup(home);
                }
            }
            catch (CVUException e) {
                Trace.out((String)"ERROR: Problem in getting OS DBA for ASM group");
                Trace.out((Exception)e);
                return null;
            }
        }
        return asmAdminGroup;
    }

    private List<Task> getTaskListPostDBConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        try {
            Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
            Collection<DatabaseConnectInfo> dbConInfos = DatabaseConnectInfo.getDatabaseConnectInfos();
            for (DatabaseConnectInfo dbConInfo : dbConInfos) {
                TaskEZConnect task = new TaskEZConnect(crsVersion, dbConInfo.dbUniqueName());
                task.setNodeList(nodeList);
                taskList.add(task);
            }
            taskList.add(new TaskAuditFileDestCheck(crsVersion, dbConInfos));
            taskList.add(new TaskOSDbGroupsExistence(crsVersion, dbConInfos));
        }
        catch (DatabaseConnectInfoException exDC) {
            Trace.out((String)("DatabaseConnectInfoException occured while getting databases conect info. message " + exDC.getMessage()));
            throw new TaskFactoryException(exDC);
        }
        this.addGroupChecks(taskList, null, nodeList, true);
        String dbHome = VerificationUtil.getVariableValue("ORACLE_HOME");
        String dbVersion = VerificationUtil.getVariableValue("SRC_RAC_HOME_VERSION");
        if ((VerificationUtil.isStringGood(VerificationUtil.getVariableValue("BASELINE_COLLECT")) || VerificationUtil.isCVUResource()) && VerificationUtil.isStringGood(dbHome)) {
            TaskSoftwareDistribution taskSD = new TaskSoftwareDistribution(nodeList);
            taskSD.setNodeList(nodeList);
            taskSD.setSoftwareComponent("database");
            taskSD.setSoftwareComponentHome(dbHome);
            taskSD.setRelease(dbVersion);
            if (!VerificationUtil.isCVUResource()) {
                taskSD.setAll(!"true".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_COLLECT_BIN_LIB_FILES")));
            }
            taskList.add(taskSD);
        }
        return taskList;
    }

    private List<Task> getTaskListPreDBConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String orclHome = null;
        ParamPreReqDBConfig pdc = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7603", false));
            }
            pdc = (ParamPreReqDBConfig)this.m_param;
            orclHome = pdc.getOrclHome();
        }
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeCon, taskMulticast, taskASMIntegrity);
        taskList.add(taskNodeCon);
        this.addTask(taskList, taskMulticast);
        this.addGroupChecks(taskList, null, nodeList, true);
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_DB_CONFIG);
        taskList.addAll(sysReqTaskList);
        TaskCRSIntegrity taskCRSI = new TaskCRSIntegrity(nodeList);
        taskList.add(taskCRSI);
        TaskNodeAppCreation taskNAC = new TaskNodeAppCreation(nodeList);
        taskList.add(taskNAC);
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
            taskTZ.setTaskType(1);
            taskList.add(taskTZ);
        }
        if (this.isASMIntegrityRequired(taskASMIntegrity, true, actCRSVer)) {
            taskList.add(taskASMIntegrity);
        }
        return taskList;
    }

    private List<Task> getTaskListPreSIDBConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String orclHome = null;
        ParamPreReqDBConfig pdc = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7603", false));
            }
            pdc = (ParamPreReqDBConfig)this.m_param;
            orclHome = pdc.getOrclHome();
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_DB_CONFIG);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        try {
            if (new ClusterwareInfo().isHAConfigured()) {
                TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
                taskList.add(taskHAI);
                TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
                taskOLRI.setHomeType("HA");
                taskList.add(taskOLRI);
            }
        }
        catch (InstallException e) {
            throw new TaskFactoryException(e);
        }
        return taskList;
    }

    private List<Task> getTaskListPreSIHAInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        Trace.out((String)"getting pre SIHA install task list");
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_HA_INST);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        boolean isUpgrade = VerificationUtil.isUpgrade();
        if (nativeSystem.isUnixSystem() && isUpgrade && m_isAPImode) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"UPGRADE Case - Found existing old version of Restart installation, Adding Restart User consistency check.");
            }
            TaskCRSUserConsistent taskCRSUserCon = new TaskCRSUserConsistent(nodeList);
            taskCRSUserCon.setSIHA(true);
            taskList.add(taskCRSUserCon);
        }
        if (nativeSystem.isUnixSystem() && isUpgrade) {
            Trace.out((String)"checking if asm upgrade checks needs to be added");
            this.addASMUpgradeChecks(taskList, nodeList, true);
        }
        return taskList;
    }

    private List<Task> getTaskListPreSIDBInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String ignoreDBACheckVal;
        ErrorDescription errDesc = null;
        boolean isClientInstall = false;
        boolean ignoreDBAChecks = false;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_DB_INST);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        String clientInstall = VerificationUtil.getVariableValue("CLIENT_INSTALL");
        if (VerificationUtil.isStringGood(clientInstall) && clientInstall.trim().equalsIgnoreCase("true")) {
            isClientInstall = true;
        }
        if (VerificationUtil.isStringGood(ignoreDBACheckVal = VerificationUtil.getVariableValue("IGNORE_DBA_CHECK")) && ignoreDBACheckVal.trim().equalsIgnoreCase("true")) {
            ignoreDBAChecks = true;
        }
        if (isClientInstall) {
            return taskList;
        }
        try {
            if (new ClusterwareInfo().isHAConfigured()) {
                TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
                taskList.add(taskHAI);
                TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
                taskOLRI.setHomeType("HA");
                taskList.add(taskOLRI);
                if (nativeSystem.isUnixSystem() && !ignoreDBAChecks) {
                    Result result = new Result(nodeList[0]);
                    String osdbaGroup = VerificationUtil.getVariableValue("DBA_GROUP");
                    Trace.out((String)("OSDBA Group retrieved = > " + osdbaGroup + "<"));
                    if (osdbaGroup == null) {
                        errDesc = new ErrorDescription("5461", new String[]{"DBA_GROUP"}, s_msgBundle);
                        result.addErrorDescription(errDesc);
                        result.setStatus(2);
                    } else {
                        String crsUser = VerificationUtil.getCRSUser(nodeList[0], result, true);
                        Trace.out((String)("CRS User retrieved = > " + crsUser + "<"));
                        if (result.getStatus() == 1 && crsUser != null) {
                            TaskGroupMembership grpMemTask = new TaskGroupMembership(crsUser, osdbaGroup);
                            grpMemTask.setNodeList(nodeList);
                            taskList.add(grpMemTask);
                        }
                    }
                    if (result.getStatus() == 2) {
                        List<VerificationError> errorList = result.getErrors();
                        String errorMsg = new String("");
                        for (VerificationError err : errorList) {
                            errorMsg = errorMsg + LSEP + "ERRORMSG(" + result.getNode() + "): " + err.getErrorMessage();
                        }
                        throw new TaskFactoryException(errorMsg);
                    }
                }
            }
        }
        catch (InstallException e) {
            throw new TaskFactoryException(e);
        }
        return taskList;
    }

    private List<Task> getTaskListPreHAConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqHAConfig param = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqHAConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7604", false));
            }
            param = (ParamPreReqHAConfig)this.m_param;
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_HA_CONFIG);
        taskList.addAll(sysReqTaskList);
        return taskList;
    }

    private List<Task> getTaskListPostCRSInst(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        TaskClusterMgrIntegrity taskCluMgrIntg = new TaskClusterMgrIntegrity(nodeList);
        TaskClusterIntegrity taskCluIntg = new TaskClusterIntegrity(nodeList);
        TaskOCRIntegrity taskOCRIntg = new TaskOCRIntegrity(nodeList);
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(nodeList);
        TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
        TaskScan taskScan = new TaskScan(nodeList);
        TaskUSMUdevChecks taskOCRUdev = null;
        TaskUSMUdevChecks taskVDiskUdev = null;
        TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        TaskASMIntegrity taskASMIntg = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeCon, taskMulticast, taskASMIntg);
        taskList.add(taskNodeCon);
        this.addTask(taskList, taskMulticast);
        if (VerificationUtil.isUDEVSupported()) {
            taskOCRUdev = new TaskUSMUdevChecks(nodeList);
            taskOCRUdev.setOCRUDevCheck();
            taskVDiskUdev = new TaskUSMUdevChecks(nodeList);
            taskVDiskUdev.setVDiskUDevCheck();
        }
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        Version actCRSVerObj = VerificationUtil.getCRSActiveVersionObj();
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
            taskTZ.setTaskType(1);
            taskList.add(taskTZ);
        }
        TaskVotingDisk taskVoteDsk = new TaskVotingDisk(nodeList);
        boolean checkASMIntg = false;
        if (this.isASMIntegrityRequired(taskASMIntg, true, null)) {
            checkASMIntg = true;
        }
        Trace.out((String)(" asm integrity check is : " + checkASMIntg));
        taskList.add(taskCluMgrIntg);
        TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
        if (nativeSystem.isUnixSystem()) {
            if (VerificationUtil.isUDEVSupported()) {
                taskList.add(taskOCRUdev);
                taskList.add(taskVDiskUdev);
            }
            if (!VerificationUtil.isCVUTestEnv()) {
                taskList.add(taskUM);
            }
        }
        taskList.add(taskCluIntg);
        taskList.add(taskOCRIntg);
        taskList.add(taskCRSIntg);
        if (actCRSVer != null) {
            Trace.out((String)("Active CRS Version is: " + actCRSVer));
            if (!actCRSVer.startsWith("10.1")) {
                Trace.out((String)"==== Adding nodeapp & scan tasks to post crsinst stage");
                taskList.add(taskNodeApp);
            }
            if (!VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                taskList.add(taskScan);
                taskOLRI.setHomeType("CRS");
                taskList.add(taskOLRI);
                TaskGNSIntegrity taskGNS = this.checkGNSConfiguration(nodeList);
                if (taskGNS != null) {
                    taskList.add(taskGNS);
                }
            }
        } else {
            Trace.out((String)"Active CRS Version is NULL");
        }
        taskList.add(taskVoteDsk);
        if (!checkASMIntg) {
            checkASMIntg = this.addASMRunningChecks(nodeList, taskASMIntg, (ParamPreReqCRSInst)this.m_param, false, false, null);
        }
        if (checkASMIntg) {
            taskList.add(taskASMIntg);
        }
        if (nativeSystem.isUnixSystem()) {
            try {
                Result result = new Result(VerificationUtil.getLocalNodename());
                String crsUser = VerificationUtil.getCRSUser(result, false);
                if (crsUser != null) {
                    TaskUserNotInGroup taskRoot = new TaskUserNotInGroup(nodeList, crsUser, "root");
                    taskList.add(taskRoot);
                }
            }
            catch (NodelistNotFoundException e) {
                Trace.out((String)"NodelistNotFoundException exception is thrown");
            }
        }
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            taskList.add(taskCTSS);
        }
        TaskVIPSubnetCheck taskVIPSubnetCheck = new TaskVIPSubnetCheck(nodeList);
        taskList.add(taskVIPSubnetCheck);
        try {
            CRSCTLUtil ct = new CRSCTLUtil(VerificationUtil.getCRSHome());
            if (ct.isIPMIConfigured() && nodeList.length > 1) {
                TaskIPMIChecks taskIPMI = new TaskIPMIChecks(nodeList);
                taskList.add(taskIPMI);
            }
        }
        catch (CmdToolUtilException cte) {
            Trace.out((String)"Exception while attempting to determine IPMI configuration");
            Trace.out((String)("CmdToolUtilException :" + cte.getMessage()));
        }
        try {
            if (NodeManagerFactory.getInstance().getNodeManager().isBigCluster()) {
                Trace.out((String)"adding TaskValidateNodeRoles");
                TaskValidateNodeRoles taskValidateNodeRoles = new TaskValidateNodeRoles(nodeList);
                taskList.add(taskValidateNodeRoles);
            }
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured. msg: " + nmEx.getMessage()));
            throw new TaskFactoryException(nmEx);
        }
        String crsHome = VerificationUtil.getVariableValue("CRS_HOME");
        if ((VerificationUtil.isStringGood(VerificationUtil.getVariableValue("BASELINE_COLLECT")) || VerificationUtil.isCVUResource()) && VerificationUtil.isStringGood(crsHome)) {
            TaskSoftwareDistribution taskSD = new TaskSoftwareDistribution(nodeList);
            taskSD.setNodeList(nodeList);
            taskSD.setSoftwareComponent("crs");
            taskSD.setSoftwareComponentHome(crsHome);
            taskSD.setRelease(actCRSVer);
            if (!VerificationUtil.isCVUResource()) {
                taskSD.setAll(!"true".equalsIgnoreCase(VerificationUtil.getVariableValue("BASELINE_COLLECT_BIN_LIB_FILES")));
            }
            taskList.add(taskSD);
        }
        return taskList;
    }

    private List<Task> getTaskListPostHAConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskHAIntegrity taskHAIntg = new TaskHAIntegrity(nodeList);
        TaskOLRIntegrity taskOLRIntg = new TaskOLRIntegrity(nodeList);
        taskOLRIntg.setHomeType("HA");
        taskList.add(taskHAIntg);
        taskList.add(taskOLRIntg);
        return taskList;
    }

    private List<Task> getTaskListPostHWOSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqHWOSSetup param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqHWOSSetup)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7606", false));
            }
            param = (ParamPreReqHWOSSetup)this.m_param;
        }
        this.addNodeConnectivityChecks(nodeList, taskList, false, this.isLocalNodeCRSRunning(), VerificationUtil.getLocalHostName(), null, null);
        if (nativeSystem.isUnixSystem()) {
            TaskUsersWithSameID taskMultRootUID = new TaskUsersWithSameID(nodeList, "0");
            taskList.add(taskMultRootUID);
        }
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
        taskTZ.setTaskType(0);
        taskList.add(taskTZ);
        TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
        if (param != null && param.getStorageIDlist() != null) {
            taskSSAccess.setStorageIDlist(param.getStorageIDlist());
        }
        taskList.add(taskSSAccess);
        if (nativeSystem.isUnixSystem()) {
            sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(nodeList);
            taskList.add(taskNSS);
        }
        return taskList;
    }

    private List<Task> getTaskListPreCFSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCFSSetup param = null;
        if (this.m_param == null) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7516", false));
        }
        if (!(this.m_param instanceof ParamPreReqCFSSetup)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7605", false));
        }
        param = (ParamPreReqCFSSetup)this.m_param;
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        taskList.add(taskNodeCon);
        this.addTask(taskList, taskMulticast);
        if (param != null && param.getStorageIDlist() != null) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
            taskSSAccess.setStorageIDlist(param.getStorageIDlist());
            taskList.add(taskSSAccess);
        }
        return taskList;
    }

    private List<Task> getTaskListPostCFSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCFSSetup param = null;
        if (this.m_param == null) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7516", false));
        }
        if (!(this.m_param instanceof ParamPreReqCFSSetup)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7605", false));
        }
        param = (ParamPreReqCFSSetup)this.m_param;
        TaskCFSIntegrity taskCFSIntg = new TaskCFSIntegrity(nodeList, param.getFileSystem());
        taskList.add(taskCFSIntg);
        return taskList;
    }

    private List<Task> getTaskListPreNodeAdd(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        TaskGNSIntegrity taskGNS;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        ArrayList<Task> taskList = new ArrayList<Task>();
        String crsHome = VerificationUtil.getCRSHome();
        String[] newClusterNodes = null;
        String[] oneExistPlusNew = null;
        ArrayList<String> tmpNodeList = new ArrayList<String>();
        String localNode = VerificationUtil.getLocalHostName();
        ParamPreReqNodeAddDel param = null;
        VerifyStorage checkCRSHomePath = new VerifyStorage();
        boolean pSharedOnCluster = false;
        Trace.out((String)("nodeList :" + LSEP + "\t" + VerificationUtil.strArr2List(nodeList)));
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        String[] clusterNodes = param.getValidClusterNodes();
        newClusterNodes = param.getValidNewClusterNodes();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Parameters: " + param.toString()));
        }
        if (!tmpNodeList.contains(localNode)) {
            tmpNodeList.add(localNode);
        }
        for (String nodeToAdd : nodeList) {
            if (tmpNodeList.contains(nodeToAdd)) continue;
            tmpNodeList.add(nodeToAdd);
        }
        oneExistPlusNew = tmpNodeList.toArray(new String[0]);
        this.addCVUQDiskPackageCheck(newClusterNodes, taskList);
        TaskNodeAddDelete taskNodeAdd = new TaskNodeAddDelete(nodeList);
        taskNodeAdd.setClusterNodes(clusterNodes);
        taskNodeAdd.setNewClusterNodes(newClusterNodes);
        taskNodeAdd.setTaskType(0);
        taskList.add(taskNodeAdd);
        TaskNodeConnectivity taskNodeConn = new TaskNodeConnectivity(param.getValidNewClusterNodes());
        taskNodeConn.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(param.getValidNewClusterNodes());
        TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeConn, taskMulticast, taskASMIntegrity);
        taskList.add(taskNodeConn);
        this.addTask(taskList, taskMulticast);
        if (!CVUHelperUtil.isASMLocal()) {
            taskASMIntegrity.setPreCheck(true);
            taskList.add(taskASMIntegrity);
        } else {
            Trace.out((String)"ASM integrity check skipped as it is a Local ASM");
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(oneExistPlusNew, VerificationType.PREREQ_CRS_INST, param.getNodes());
        try {
            pSharedOnCluster = checkCRSHomePath.isShared(crsHome, clusterNodes.length == 1 ? oneExistPlusNew : clusterNodes, OracleFileType.RAC_SOFTWARE, "12.1");
        }
        catch (StorageException se) {
            Trace.out((String)("STORAGEEXCEPTION: " + se.getMessage()));
        }
        catch (MultiNodeException mne) {
            Trace.out((String)("MULTINODEEXCEPTION: " + mne.getMessage()));
        }
        if (pSharedOnCluster) {
            for (Task sysTask : sysReqTaskList) {
                String taskName = sysTask.getClass().getName();
                Trace.out((int)1, (String)("checking sysReqTaskList entry: '" + taskName + "'"));
                if (!taskName.contains("TaskContainerFreeSpace") || !sysTask.hasSubtasks()) continue;
                try {
                    for (VerificationTask verTask : sysTask.getSubtasks()) {
                        TaskFreeSpace taskFS = (TaskFreeSpace)verTask;
                        if (!taskFS.getLocations().contains(crsHome)) continue;
                        Double newSizeVal = new Double(".5");
                        newSizeVal = newSizeVal * (double)nodeList.length;
                        StorageSize newSize = new StorageSize(newSizeVal, StorageUnit.GBYTE);
                        Trace.out((String)("sysReqTask[TaskFreeSpace] before change: " + taskFS.toString()));
                        taskFS.setFreeSpace(newSize);
                        Trace.out((String)("sysReqTask[TaskFreeSpace] AFTER change: " + taskFS.toString()));
                    }
                }
                catch (SubtasksUnavailableException sue) {
                    Trace.out((String)("SUBTASKSUNAVAILABLEEXCEPTOIN: " + sue.getMessage()));
                    throw new TaskFactoryException(sue);
                }
            }
        }
        taskList.addAll(sysReqTaskList);
        this.addGroupChecks(taskList, oneExistPlusNew, nodeList, false);
        if (!nativeSystem.isUnixSystem()) {
            TaskCheckFirewallSetting taskFirewall = new TaskCheckFirewallSetting(nodeList);
            taskList.add(taskFirewall);
        }
        if (VerificationUtil.isPlatformLinux()) {
            TaskASMLibChecks taskASMLib = new TaskASMLibChecks(oneExistPlusNew);
            taskList.add(taskASMLib);
        }
        Version actCRSVerObj = VerificationUtil.getCRSActiveVersionObj();
        ClusterInfo ci = null;
        ResultSet resultSet = new ResultSet();
        String[] ocrLocations = VerificationUtil.getOCRLocations(actCRSVerObj, resultSet);
        if (ocrLocations != null && ocrLocations.length > 0) {
            TaskOCRIntegrity ocrIntgr = new TaskOCRIntegrity(oneExistPlusNew);
            ocrIntgr.setPreReq(true);
            ocrIntgr.setOcrLocArr(ocrLocations);
            taskList.add(ocrIntgr);
        }
        try {
            VoteDiskInfo[] voteDiskList;
            ArrayList<String> voteDskLocs = new ArrayList<String>();
            ci = new ClusterInfo(VerificationUtil.getCRSHome(), actCRSVerObj);
            for (VoteDiskInfo vdiL : voteDiskList = ci.getVoteDiskLocations()) {
                voteDskLocs.add(vdiL.getPath());
            }
            if (voteDskLocs.size() != 0) {
                TaskVotingDisk taskVoteDsk = new TaskVotingDisk(nodeList);
                taskVoteDsk.setPreReq(true);
                taskVoteDsk.setDiskList(voteDiskList);
                taskVoteDsk.setDiskPaths(voteDskLocs.toArray(new String[voteDskLocs.size()]));
                taskList.add(taskVoteDsk);
            }
        }
        catch (ClusterInfoException cie) {
            Trace.out((String)("CLUSTERINFO EXCEPTION: \n" + cie.getMessage()));
        }
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(oneExistPlusNew);
        taskTZ.setTaskType(0);
        taskList.add(taskTZ);
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        TaskNTP taskNTP = new TaskNTP(oneExistPlusNew);
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            taskNTP.setPreCheck(true);
        }
        taskList.add(taskNTP);
        if (nativeSystem.isUnixSystem()) {
            TaskUserNotInGroup taskUserNotRoot = new TaskUserNotInGroup(oneExistPlusNew, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskUserNotRoot);
            TaskResolvConfIntegrity taskResolvConf = new TaskResolvConfIntegrity(oneExistPlusNew);
            taskList.add(taskResolvConf);
            sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(nodeList);
            taskList.add(taskNSS);
        }
        if ((taskGNS = this.checkGNSConfiguration(clusterNodes)) != null) {
            taskList.add(taskGNS);
        }
        String[] vipList = param.getVipList();
        String[] nodesWithVip = param.getNodesWithVip();
        Trace.out((String)("Processing nodes with VIP list: '" + VerificationUtil.strArr2List(nodesWithVip) + "'"));
        Trace.out((String)("Processing vip list: '" + VerificationUtil.strArr2List(vipList) + "'"));
        boolean isDHCPServerConfigured = false;
        try {
            isDHCPServerConfigured = new ClusterwareInfo().isDHCPServerConfigured(crsHome);
        }
        catch (InstallException e) {
            Trace.out((String)("InstallException:: " + e.getMessage() + LSEP));
            Trace.out((Exception)((Object)e));
            throw new TaskFactoryException(e);
        }
        Trace.out((String)("isDHCPServerConfigured=" + isDHCPServerConfigured));
        if (!isDHCPServerConfigured) {
            if (vipList != null && vipList.length > 0 && vipList.length == nodesWithVip.length) {
                TaskVIPSubnetCheck taskVIPSubnetCheck = new TaskVIPSubnetCheck(clusterNodes);
                taskVIPSubnetCheck.addNodes(nodesWithVip, vipList);
                taskList.add(taskVIPSubnetCheck);
                Trace.out((String)"TaskVIPSubnetCheck has been added.");
            } else if (vipList != null && vipList.length > 0) {
                Trace.out((String)("Cannot match node list: " + VerificationUtil.strArr2List(nodesWithVip) + " To VIP list: " + VerificationUtil.strArr2List(vipList)));
            } else {
                Trace.out((String)"vipList is empty");
            }
        }
        try {
            CRSCTLUtil ct = new CRSCTLUtil(VerificationUtil.getCRSHome());
            if (ct.isIPMIConfigured()) {
                TaskIPMIChecks taskIPMI = new TaskIPMIChecks(nodeList);
                taskIPMI.setIsPreCRS(true);
                taskList.add(taskIPMI);
            }
        }
        catch (CmdToolUtilException cte) {
            Trace.out((String)"Exception while attempting to determine IPMI configuration");
            Trace.out((String)("CmdToolUtilException :" + cte.getMessage()));
        }
        try {
            NodeManager nodeMgr = NodeManagerFactory.getInstance().getNodeManager();
            if (nodeMgr.isBigCluster()) {
                Trace.out((String)"adding TaskValidateNodeRoles");
                TaskValidateNodeRoles taskValidateNodeRoles = new TaskValidateNodeRoles(clusterNodes);
                taskValidateNodeRoles.addNodes(nodeMgr.getNewNodes(NodeRoleCapability.ALL));
                taskList.add(taskValidateNodeRoles);
            }
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured. msg: " + nmEx.getMessage()));
            throw new TaskFactoryException(nmEx);
        }
        return taskList;
    }

    private List<Task> getTaskListPreRACNodeAdd(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        TaskGNSIntegrity taskGNS;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        ArrayList<Task> taskList = new ArrayList<Task>();
        String crsHome = VerificationUtil.getCRSHome();
        String[] newClusterNodes = null;
        String[] oneExistPlusNew = null;
        String[] oneExistPlusCRSNew = null;
        ArrayList<String> tmpNodeList = new ArrayList<String>();
        String localNode = VerificationUtil.getLocalHostName();
        ParamPreReqNodeAddDel param = null;
        VerifyStorage checkCRSHomePath = new VerifyStorage();
        boolean pSharedOnCluster = false;
        List<Object> sysReqTaskList = new ArrayList();
        Trace.out((String)("nodeList :" + LSEP + "\t" + VerificationUtil.strArr2List(nodeList)));
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        if (!param.isRACHome()) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        String[] clusterNodes = param.getValidClusterNodes();
        newClusterNodes = param.getValidNewClusterNodes();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Parameters: " + param.toString()));
        }
        tmpNodeList.add(localNode);
        for (String nodeToAdd : nodeList) {
            if (tmpNodeList.contains(nodeToAdd)) continue;
            tmpNodeList.add(nodeToAdd);
        }
        oneExistPlusNew = tmpNodeList.toArray(new String[0]);
        tmpNodeList.clear();
        try {
            for (String nodeToAdd : nodeList) {
                if (tmpNodeList.contains(nodeToAdd) || !new ClusterwareInfo().isCRSConfiguredOnNode(nodeToAdd)) continue;
                tmpNodeList.add(nodeToAdd);
            }
            if (tmpNodeList.size() > 0) {
                oneExistPlusCRSNew = tmpNodeList.toArray(new String[0]);
            }
        }
        catch (InstallException e) {
            throw new TaskFactoryException(e);
        }
        sysReqTaskList = this.getTaskListSysReq(oneExistPlusNew, VerificationType.PREREQ_DB_INST, param.getNodes());
        taskList.addAll(sysReqTaskList);
        if (oneExistPlusCRSNew != null) {
            TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(oneExistPlusCRSNew);
            taskCRSIntg.setVersionConsistencyMandatory(true);
            taskCRSIntg.setVerificationType(VerificationType.PREREQ_DB_INST);
            taskList.add(taskCRSIntg);
            TaskClusterMgrIntegrity taskCluMgrIntg = new TaskClusterMgrIntegrity(oneExistPlusCRSNew);
            taskList.add(taskCluMgrIntg);
            String reqRel = "12.1";
            if (!"10gR1".equalsIgnoreCase(reqRel) && !"10.1".equalsIgnoreCase(reqRel)) {
                Trace.out((String)"==== Adding Nodeapp check RACNodeAdd");
                TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(oneExistPlusCRSNew);
                taskList.add(taskNodeApp);
            }
        }
        if (nativeSystem.isUnixSystem() && !VerificationUtil.isCVUTestEnv()) {
            Trace.out((String)"==== Adding UserMask check for RACNodeAdd");
            TaskUserMask taskUM = new TaskUserMask(oneExistPlusNew, VerificationUtil.getDefaultUmask());
            taskList.add(taskUM);
        }
        Trace.out((String)"==== Adding group checks for RACNodeAdd");
        this.addGroupChecks(taskList, oneExistPlusNew, nodeList, true);
        TaskNodeAddDelete taskNodeAdd = new TaskNodeAddDelete(nodeList);
        taskNodeAdd.setClusterNodes(clusterNodes);
        taskNodeAdd.setNewClusterNodes(newClusterNodes);
        taskNodeAdd.setTaskType(0);
        taskNodeAdd.setRACHome(true);
        taskList.add(taskNodeAdd);
        TaskNodeConnectivity taskNodeConn = new TaskNodeConnectivity(param.getValidNewClusterNodes());
        taskNodeConn.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(param.getValidNewClusterNodes());
        TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeConn, taskMulticast, taskASMIntegrity);
        taskList.add(taskNodeConn);
        this.addTask(taskList, taskMulticast);
        if (!nativeSystem.isUnixSystem()) {
            TaskCheckFirewallSetting taskFirewall = new TaskCheckFirewallSetting(nodeList);
            taskList.add(taskFirewall);
        }
        Version actCRSVerObj = VerificationUtil.getCRSActiveVersionObj();
        Object ci = null;
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(oneExistPlusNew);
        taskTZ.setTaskType(0);
        taskList.add(taskTZ);
        if (nativeSystem.isUnixSystem()) {
            TaskUserNotInGroup taskUserNotRoot = new TaskUserNotInGroup(oneExistPlusNew, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskUserNotRoot);
            TaskResolvConfIntegrity taskResolvConf = new TaskResolvConfIntegrity(oneExistPlusNew);
            taskList.add(taskResolvConf);
            sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(nodeList);
            taskList.add(taskNSS);
        }
        if ((taskGNS = this.checkGNSConfiguration(clusterNodes)) != null) {
            taskList.add(taskGNS);
        }
        String requiredDBVersion = new Version().toString();
        TaskDBCRSVersionCompatibility taskDBCRSVerComp = new TaskDBCRSVersionCompatibility(nodeList, requiredDBVersion);
        taskList.add(taskDBCRSVerComp);
        if (nativeSystem.isUnixSystem()) {
            TaskDBUserConsistent taskDBUserCon = new TaskDBUserConsistent(nodeList);
            String srcDBHome = VerificationUtil.getVariableValue("SRC_RAC_HOME");
            if (srcDBHome != null) {
                taskDBUserCon.setDBHome(srcDBHome);
                taskList.add(taskDBUserCon);
            }
        }
        return taskList;
    }

    private List<Task> getTaskListPostNodeAdd(String[] nodeList) throws TaskFactoryException {
        NativeSystem nativeSystem;
        ArrayList<Task> taskList = new ArrayList<Task>();
        String[] validNodes = null;
        String[] newClusterNodes = null;
        String localNode = null;
        ParamPreReqNodeAddDel param = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        String[] clusterNodes = param.getValidClusterNodes();
        validNodes = param.getValidNodes();
        newClusterNodes = param.getValidNewClusterNodes();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nParameters: " + param.toString()));
        }
        ArrayList<String> clusterList = new ArrayList<String>(Arrays.asList(newClusterNodes));
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            throw new TaskFactoryException(s_msgBundle.getMessage("0002", false));
        }
        if (CVUHelperUtil.getNeworkConfig(1, true)) {
            Trace.out((String)"adding node connectivity task for default network");
            TaskNodeConnectivity taskVIPConnectivity = new TaskNodeConnectivity(newClusterNodes);
            taskVIPConnectivity.setTaskType(0);
            Trace.out((String)"adding multicast check ");
            TaskMulticastCheck multicastCheck = new TaskMulticastCheck(newClusterNodes);
            TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(newClusterNodes);
            this.getNetIfFromVar(taskVIPConnectivity, multicastCheck, taskASMIntegrity);
            taskList.add(taskVIPConnectivity);
            taskList.add(multicastCheck);
        }
        TaskClusterIntegrity taskClusterIntegrity = new TaskClusterIntegrity(newClusterNodes);
        taskList.add(taskClusterIntegrity);
        TaskNodeAddDelete taskNodeAdd = new TaskNodeAddDelete(validNodes);
        taskNodeAdd.setClusterNodes(clusterNodes);
        taskNodeAdd.setNewClusterNodes(newClusterNodes);
        taskNodeAdd.setTaskType(0);
        taskList.add(taskNodeAdd);
        TaskPeerCompatibility taskPeerCompat = new TaskPeerCompatibility();
        taskPeerCompat.setReferenceNode(localNode);
        Trace.out((String)("\n Peer: local node: " + localNode + "\n Peer: node list: " + VerificationUtil.strArr2List(newClusterNodes)));
        taskPeerCompat.setNodeList(param.getValidNodes());
        TaskNodeConnectivity taskNodeConn = new TaskNodeConnectivity(newClusterNodes);
        taskNodeConn.setTaskType(0);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(newClusterNodes);
        TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
        this.getNetIfFromOifcfg(taskNodeConn, taskMulticast, taskASMIntegrity);
        taskList.add(taskNodeConn);
        this.addTask(taskList, taskMulticast);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(newClusterNodes);
        taskList.add(taskNodeApp);
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskScan taskScan = new TaskScan(nodeList);
            taskList.add(taskScan);
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            TaskUserNotInGroup taskUserNotRoot = new TaskUserNotInGroup(nodeList, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskUserNotRoot);
        }
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
            taskList.add(taskCTSS);
        }
        return taskList;
    }

    private List<Task> getTaskListPostNodeDel(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        String[] clusterNodes = null;
        ParamPreReqNodeAddDel param = null;
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        clusterNodes = param.getValidClusterNodes();
        Trace.out((String)("nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        Trace.out((String)("clusterNodes='" + VerificationUtil.strArr2List(clusterNodes) + "'"));
        TaskNodeAddDelete taskNodeDel = new TaskNodeAddDelete(nodeList);
        taskNodeDel.setClusterNodes(clusterNodes);
        taskNodeDel.setTaskType(1);
        taskList.add(taskNodeDel);
        return taskList;
    }

    private List<Task> getTaskListPreUSMConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqUSMConfig pusmc = null;
        String asmadmingrp = null;
        if (!(this.m_param instanceof ParamPreReqUSMConfig)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7607", false));
        }
        pusmc = (ParamPreReqUSMConfig)this.m_param;
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        TaskASMDeviceChecks taskASMDevChecks = new TaskASMDeviceChecks(nodeList);
        String[] devarr = pusmc.getASMDeviceArr();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Device string from ParamPreReqUSMConfig = " + devarr));
        }
        taskASMDevChecks.setDeviceString(devarr);
        taskASMDevChecks.setReferenceOwner(VerificationUtil.getDefaultCRSUser());
        try {
            asmadmingrp = VerificationUtil.getASMAdminGroup();
        }
        catch (CVUException ce) {
            Trace.out((String)("Exception occured while getting ASM admin group ::" + ce.getMessage()));
            throw new TaskFactoryException(ce);
        }
        taskASMDevChecks.setReferenceGroup(asmadmingrp);
        taskASMDevChecks.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        taskASMDevChecks.setVersion(actCRSVer);
        TaskUSMDriverChecks taskUSMDriverChecks = new TaskUSMDriverChecks(nodeList);
        Trace.out((int)5, (String)"Adding USM driver checks to task list");
        taskList.add(taskCRSIntg);
        taskList.add(taskASMDevChecks);
        taskList.add(taskUSMDriverChecks);
        return taskList;
    }

    private List<Task> getTaskListPostUSMConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        try {
            TaskASMIntegrity taskASMIntegrity = new TaskASMIntegrity(nodeList);
            taskASMIntegrity.setNetworkInfoFromOifcfg();
            taskList.add(taskASMIntegrity);
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("Exception occured while setting network info from oifcfg. msg=" + cvuEx.getMessage()));
            throw new TaskFactoryException(cvuEx);
        }
        TaskACFSIntegrity taskACFSIntegrity = new TaskACFSIntegrity(nodeList);
        taskList.add(taskACFSIntegrity);
        if (VerificationUtil.isUDEVSupported()) {
            TaskUSMUdevChecks taskUSMDevCheck = new TaskUSMUdevChecks(nodeList);
            taskList.add(taskUSMDevCheck);
        }
        return taskList;
    }

    private List<Task> getTaskListSysReq(String[] nodeList, VerificationType verType) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskListSysReq(nodeList, verType, null);
    }

    private List<Task> getTaskListFarmHealth(String[] nodeList) throws TaskFactoryException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnixSystem = nativeSystem.isUnixSystem();
        ArrayList<Task> taskList = new ArrayList<Task>();
        String configFile = m_pm.getInstallConfigFile();
        String val_INTERCONNECT_LIST = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        String val_SCAN_NAME = VerificationUtil.getVariableValue("SCAN_NAME");
        String val_HOST_VIP_NAMES = VerificationUtil.getVariableValue("HOST_VIP_NAMES");
        String val_CLUSTERWARE_STORAGE = VerificationUtil.getVariableValue("CLUSTERWARE_STORAGE");
        Trace.out((String)(LSEP + "val_INTERCONNECT_LIST='" + val_INTERCONNECT_LIST + "'" + LSEP + "val_SCAN_NAME='" + val_SCAN_NAME + "'" + LSEP + "val_HOST_VIP_NAMES='" + val_HOST_VIP_NAMES + "'" + LSEP + "val_CLUSTERWARE_STORAGE='" + val_CLUSTERWARE_STORAGE + "'"));
        TaskAdminPrivileges taskSSHequiv = new TaskAdminPrivileges(nodeList, "user_equiv");
        taskSSHequiv.setUserEquivCheckTypeSet(EnumSet.of(UserEquivCheckType.CV_EQUIV_SSH));
        taskList.add(taskSSHequiv);
        if (!VerificationUtil.isStringGood(val_INTERCONNECT_LIST)) {
            throw new TaskFactoryException(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{"INTERCONNECT_LIST", configFile}));
        }
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        TaskMulticastCheck taskMulticast = new TaskMulticastCheck(nodeList);
        taskNodeCon.setTaskType(0);
        this.getNetIfFromVar(taskNodeCon, taskMulticast, null);
        taskList.add(taskNodeCon);
        taskList.add(taskMulticast);
        if (!VerificationUtil.isStringGood(val_SCAN_NAME)) {
            ReportUtil.printWarning(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{"SCAN_NAME", configFile}));
        } else {
            TaskScan taskScan = new TaskScan(nodeList);
            taskScan.setIsPreCRS(true);
            taskList.add(taskScan);
        }
        if (!VerificationUtil.isStringGood(val_HOST_VIP_NAMES)) {
            ReportUtil.printWarning(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{"HOST_VIP_NAMES", configFile}));
        } else {
            TaskVIPSubnetCheck taskVIPSubnetCheck = new TaskVIPSubnetCheck(nodeList);
            taskVIPSubnetCheck.setIsPreCRS(true);
            taskList.add(taskVIPSubnetCheck);
        }
        List<Integer> supportedRunLevels = VDMUtil.getSupportedRunLevels();
        TaskRunLevel taskRL = new TaskRunLevel(supportedRunLevels);
        taskRL.setNodeList(nodeList);
        taskList.add(taskRL);
        if (VerificationUtil.isStringGood(val_CLUSTERWARE_STORAGE)) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
            String[] storageArr = VerificationUtil.string2strArr(val_CLUSTERWARE_STORAGE);
            if (storageArr.length != 0) {
                taskSSAccess.setStorageIDlist(storageArr);
                taskSSAccess.setOracleFileType(OracleFileType.RAC_OCR_VDISK);
                taskList.add(taskSSAccess);
            }
        }
        if (isUnixSystem) {
            sTaskGIConfigurationFiles taskGIconfigFiles = new sTaskGIConfigurationFiles(nodeList);
            taskList.add(taskGIconfigFiles);
            TaskDomainSockets taskDomainSockets = new TaskDomainSockets();
            taskDomainSockets.setNodeList(nodeList);
            taskDomainSockets.setCheckFileAbsence(true);
            taskList.add(taskDomainSockets);
            sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(nodeList);
            taskList.add(taskNSS);
            TaskResolvConfIntegrity taskResolvConf = new TaskResolvConfIntegrity(nodeList);
            taskList.add(taskResolvConf);
        }
        return taskList;
    }

    private List<Task> getTaskListSysReq(String[] nodeList, VerificationType verType, String[] limitedAddDelNodeList) throws TaskFactoryException, PreReqNotSupportedException {
        Task[] taskArr;
        String release = null;
        String osDBAGroup = null;
        String osBackupGroup = null;
        String osDGGroup = null;
        String osKMGroup = null;
        String oraInvGroup = null;
        String oracleHome = null;
        String asmAdminGroup = null;
        boolean asmCheck = false;
        String crsHome = null;
        String haHome = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Trace.out((int)2, (String)"ENTRY");
        try {
            if (this.m_param != null) {
                if (this.m_param instanceof ParamPreReqDBInst) {
                    release = ((ParamPreReqDBInst)this.m_param).getRelease();
                    osDBAGroup = ((ParamPreReqDBInst)this.m_param).getOSDBAgroup();
                    osBackupGroup = ((ParamPreReqDBInst)this.m_param).getOSBACKUPgroup();
                    osDGGroup = ((ParamPreReqDBInst)this.m_param).getOSDGgroup();
                    osKMGroup = ((ParamPreReqDBInst)this.m_param).getOSKMgroup();
                    oraInvGroup = ((ParamPreReqDBInst)this.m_param).getOraInv();
                    oracleHome = ((ParamPreReqDBInst)this.m_param).getOrclHome();
                    crsHome = ((ParamPreReqDBInst)this.m_param).getCRSHome();
                    haHome = ((ParamPreReqDBInst)this.m_param).getHAHome();
                    asmAdminGroup = ((ParamPreReqDBInst)this.m_param).getASMAdminGroup();
                } else if (this.m_param instanceof ParamPreReqCRSInst) {
                    release = ((ParamPreReqCRSInst)this.m_param).getRelease();
                    osDBAGroup = ((ParamPreReqCRSInst)this.m_param).getOSDBAgroup();
                    oraInvGroup = ((ParamPreReqCRSInst)this.m_param).getORAINVgroup();
                    asmAdminGroup = ((ParamPreReqCRSInst)this.m_param).getASMADMINgroup();
                    asmCheck = ((ParamPreReqCRSInst)this.m_param).getASMCheck();
                    crsHome = ((ParamPreReqCRSInst)this.m_param).getCRSHome();
                } else if (this.m_param instanceof ParamPreReqDBConfig) {
                    release = ((ParamPreReqDBConfig)this.m_param).getRelease();
                    oracleHome = ((ParamPreReqDBConfig)this.m_param).getOrclHome();
                    crsHome = ((ParamPreReqDBConfig)this.m_param).getCRSHome();
                    haHome = ((ParamPreReqDBConfig)this.m_param).getHAHome();
                    oraInvGroup = ((ParamPreReqDBConfig)this.m_param).getOraInv();
                    osDBAGroup = ((ParamPreReqDBConfig)this.m_param).getOSDBAgroup();
                    asmAdminGroup = ((ParamPreReqDBConfig)this.m_param).getASMAdminGroup();
                } else if (this.m_param instanceof ParamPreReqHAConfig) {
                    osDBAGroup = ((ParamPreReqHAConfig)this.m_param).getOSDBA();
                    oraInvGroup = ((ParamPreReqHAConfig)this.m_param).getOraInv();
                }
            }
            if (osDBAGroup != null) {
                VerificationUtil.setVariableValue("DBA_GROUP", osDBAGroup);
            }
            if (osBackupGroup != null) {
                VerificationUtil.setVariableValue("BACKUPDBA_GROUP", osBackupGroup);
            }
            if (osDGGroup != null) {
                VerificationUtil.setVariableValue("DGDBA_GROUP", osDGGroup);
            }
            if (osKMGroup != null) {
                VerificationUtil.setVariableValue("KMDBA_GROUP", osKMGroup);
            }
            if (oraInvGroup != null) {
                VerificationUtil.setVariableValue("INSTALL_GROUP", oraInvGroup);
            }
            if (oracleHome != null) {
                VerificationUtil.setVariableValue("ORACLE_HOME", oracleHome);
                VerificationUtil.setVariableValue("RAC_HOME", oracleHome);
            }
            if (crsHome != null) {
                VerificationUtil.setVariableValue("CRS_HOME", crsHome);
            }
            if (haHome != null) {
                VerificationUtil.setVariableValue("HA_HOME", haHome);
            }
            if (asmAdminGroup != null && (asmCheck || this.m_param instanceof ParamPreReqDBInst || this.m_param instanceof ParamPreReqDBConfig)) {
                VerificationUtil.setVariableValue("ASM_GROUP", asmAdminGroup);
            }
            if (release == null) {
                release = VerificationUtil.getConfiguredValue("CV_ORACLE_RELEASE", false);
            }
            String xmlFile = release != null ? VerificationUtil.getPreReqXmlPath(verType, release) : VerificationUtil.getPreReqXmlPath(verType);
            Trace.out((String)("Using xmlFile: '" + xmlFile + "'"));
            XmlTaskFactory xtf = XmlTaskFactory.getInstance();
            taskArr = xtf.getTasks(verType, xmlFile, VerificationUtil.getUniqueDistributionID(), nodeList, this.isLocalNodeCRSRunning(), limitedAddDelNodeList);
        }
        catch (XmlFilePathException xfpe) {
            Trace.out((String)("XMLFILEPATHEXCEPTION: " + xfpe.getMessage()));
            throw new TaskFactoryException(xfpe);
        }
        catch (XmlParserException xpe) {
            Trace.out((String)("XMLPARSEREXCEPTION: " + xpe.getMessage()));
            throw new TaskFactoryException(xpe);
        }
        for (Task task : taskArr) {
            if (task.getNodeList() == null || task.getNodeList().length == 0) {
                task.setNodeList(nodeList);
            } else {
                Trace.out((String)(task.getTaskID() + " Already has nodes set to (" + VerificationUtil.strArr2List(task.getNodeList()) + ") hence not reseting nodes"));
            }
            if (!task.hasSubtasks()) continue;
            try {
                for (VerificationTask subTask : task.getSubtasks()) {
                    ((Task)subTask).setNodeList(nodeList);
                }
            }
            catch (SubtasksUnavailableException sue) {
                throw new TaskFactoryException(sue);
            }
        }
        ArrayList<Task> taskList = new ArrayList<Task>(Arrays.asList(taskArr));
        if (nativeSystem.isUnixSystem()) {
            TaskUsersWithSameID taskMultRootUID = new TaskUsersWithSameID(nodeList, "0");
            taskList.add(taskMultRootUID);
            if (verType.equals((Object)VerificationType.PREREQ_CRS_INST) || verType.equals((Object)VerificationType.PREREQ_DB_INST) || verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) || verType.equals((Object)VerificationType.PREREQ_SI_HA_INST) || verType.equals((Object)VerificationType.PREREQ_SI_HA_CONFIG)) {
                TaskCurrentGroupID taskCurGrpID = new TaskCurrentGroupID();
                taskCurGrpID.setNodeList(nodeList);
                taskList.add(taskCurGrpID);
            }
            sTaskRootConsistency sTRC = new sTaskRootConsistency(nodeList);
            taskList.add(sTRC);
        }
        if (!nativeSystem.isUnixSystem() && (verType.equals((Object)VerificationType.PREREQ_CRS_INST) || verType.equals((Object)VerificationType.PREREQ_DB_INST) || verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) || verType.equals((Object)VerificationType.POSTREQ_CRS_INST))) {
            TaskCheckMediaSense taskMediaSense = new TaskCheckMediaSense(nodeList);
            taskList.add(taskMediaSense);
        }
        if (verType.equals((Object)VerificationType.SYSREQ_CRS)) {
            TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
            taskTZ.setTaskType(0);
            taskList.add(taskTZ);
        }
        if (nativeSystem.isUnixSystem() && (VerificationUtil.isStringGood(VerificationUtil.getVariableValue("BASELINE_COLLECT")) || VerificationUtil.isCVUResource())) {
            TaskClusterwareConfigOutsideHome clusterwareConfig = new TaskClusterwareConfigOutsideHome();
            clusterwareConfig.setNodeList(nodeList);
            taskList.add(clusterwareConfig);
            TaskDomainSockets taskDomainSockets = new TaskDomainSockets();
            taskDomainSockets.setNodeList(nodeList);
            taskList.add(taskDomainSockets);
        }
        return taskList;
    }

    public void getNetIfFromVar(TaskNodeConnectivity taskNodeCon, TaskMulticastCheck taskMulticast, TaskASMIntegrity taskASMIntegrity) throws TaskFactoryException {
        ClusterNetworkInfo cnInfo = null;
        try {
            cnInfo = ClusterNetworkInfo.getNetworkInfoFromCVUVar();
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("Exception occured while getting network info from CVU var. msg=" + cvuEx.getMessage()));
            throw new TaskFactoryException(cvuEx);
        }
        this.getNetIfFromCNInfo(cnInfo, taskNodeCon, taskMulticast, taskASMIntegrity);
    }

    private void getNetIfFromPMArg(String node, TaskNodeConnectivity taskNodeCon, TaskMulticastCheck taskMulticast, TaskASMIntegrity taskASMIntegrity) throws TaskFactoryException {
        if (!m_pm.hasArgument(Argument.ARG_NETWORKLIST)) {
            return;
        }
        Argument argInterfaceList = m_pm.getArgument(Argument.ARG_NETWORKLIST);
        ClusterNetworkInfo cnInfo = null;
        try {
            cnInfo = ClusterNetworkInfo.getNetworkInfoFromPMArg(argInterfaceList, node);
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("Exception occured while getting network information. msg=" + cvuEx.getMessage()));
            throw new TaskFactoryException(cvuEx);
        }
        String strInterConnectList = cnInfo.getInterConnectList();
        VerificationUtil.setVariableValue("INTERCONNECT_LIST", strInterConnectList);
        this.getNetIfFromCNInfo(cnInfo, taskNodeCon, taskMulticast, taskASMIntegrity);
    }

    public void getNetIfFromOifcfg(TaskNodeConnectivity taskNodeCon, TaskMulticastCheck taskMulticast, TaskASMIntegrity taskASMIntegrity) throws TaskFactoryException {
        ClusterNetworkInfo cnInfo = null;
        try {
            Trace.out((String)"calling ClusterNetworkInfo.getNetworkInfoFromOifcfg");
            cnInfo = ClusterNetworkInfo.getNetworkInfoFromOifcfg();
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("Exception occured while getting network information. msg=" + cvuEx.getMessage()));
            throw new TaskFactoryException(cvuEx);
        }
        String strInterConnectList = cnInfo.getInterConnectList();
        VerificationUtil.setVariableValue("INTERCONNECT_LIST", strInterConnectList);
        this.getNetIfFromCNInfo(cnInfo, taskNodeCon, taskMulticast, taskASMIntegrity);
    }

    private void getNetIfFromCNInfo(ClusterNetworkInfo cnInfo, TaskNodeConnectivity taskNodeCon, TaskMulticastCheck taskMulticast, TaskASMIntegrity taskASMIntegrity) {
        String[] interFaceLst = cnInfo.getIfNames();
        String[] subnetLst = cnInfo.getSubnets();
        int[] subnetTypeLst = cnInfo.getNetTypes(true);
        if (taskNodeCon != null) {
            taskNodeCon.setInterfaceList(interFaceLst);
            taskNodeCon.setSubnetList(subnetLst);
            taskNodeCon.setSubnetTypeList(subnetTypeLst);
        }
        if (taskMulticast != null) {
            taskMulticast.setSubnetList(subnetLst);
            taskMulticast.setSubnetTypeList(subnetTypeLst);
        }
        if (taskASMIntegrity != null && cnInfo.hasNetType(128)) {
            Trace.out((String)"Found NETTYPE_ASM in network information");
            ClusterNetworkInfo asmNetInfo = cnInfo.getClusterNetworkInfo(128);
            String[] asmInterFaceLst = asmNetInfo.getIfNames();
            String[] asmSubnetLst = asmNetInfo.getSubnets();
            int asmCount = asmInterFaceLst.length;
            taskASMIntegrity.setNetworkInfo(asmInterFaceLst, asmSubnetLst, asmCount);
        }
    }

    private TaskGNSIntegrity checkGNSConfiguration(String[] nodeList) throws TaskFactoryException {
        TaskGNSIntegrity taskGNS = null;
        ResultSet gnsResultSet = new ResultSet();
        String m_localName = null;
        try {
            m_localName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            throw new TaskFactoryException(s_msgBundle.getMessage("0002", false));
        }
        if (CVUHelperUtil.getGNSDomainAndVIP(gnsResultSet, m_localName, true)) {
            taskGNS = new TaskGNSIntegrity(nodeList);
        }
        return taskGNS;
    }

    private boolean addTask(List<Task> taskList, Task task) {
        if (VerificationUtil.skipTask(task)) {
            Trace.out((String)("task " + task + " is not added to the taskList"));
            return false;
        }
        Trace.out((String)("task " + task + " is beeing added to the taskList"));
        taskList.add(task);
        return true;
    }

    private boolean isASMIntegrityRequired(TaskASMIntegrity taskASMIntegrity, boolean isPostInst, String reqRel) {
        if (!isPostInst && reqRel != null && VerificationUtil.isVersionPre(reqRel, "12.1")) {
            Trace.out((String)"pre 12.1 no asm integrity in pre");
            return false;
        }
        String asmCred = VerificationUtil.getVariableValue("ASM_CLIENTDATA");
        if (!isPostInst && asmCred != null && asmCred.length() != 0) {
            Trace.out((String)"asm credentials file specified");
            return true;
        }
        if (taskASMIntegrity.isASMNetworkExist()) {
            Trace.out((String)"asm network has been specified");
            return true;
        }
        Trace.out((String)"no asm config specified for check");
        return false;
    }

    private void addASMUpgradeChecks(List<Task> taskList, String[] nodeList, boolean isSIHA) {
        ArrayList<String> runningNodeList = new ArrayList<String>();
        ArrayList<String> failedNodeList = new ArrayList<String>();
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        try {
            Trace.out((String)"checking if asm is running");
            asmdg.checkASMRunning(nodeList, runningNodeList, failedNodeList);
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)("ASMDG exception while checking for asm " + e.getMessage()));
            return;
        }
        if (runningNodeList.size() >= 1) {
            Trace.out((String)"ASM is running");
            TaskASMMissizedDiskCheck taskASMMissizedDiskCheck = new TaskASMMissizedDiskCheck(nodeList);
            if (isSIHA) {
                taskASMMissizedDiskCheck.setSIHAMode();
            }
            taskList.add(taskASMMissizedDiskCheck);
            if (!VerificationUtil.isPlatformLinux()) {
                return;
            }
            if (!(VerificationUtil.isASMLibConfigured(nodeList) || VerificationUtil.isODASystem() || VerificationUtil.isExadataSystem())) {
                Trace.out((String)"adding default string check to task list");
                TaskUpgCheckASMDiscoveryString taskASMDefaultStringCheck = new TaskUpgCheckASMDiscoveryString(nodeList);
                if (isSIHA) {
                    taskASMDefaultStringCheck.setSIHAMode();
                }
                taskList.add(taskASMDefaultStringCheck);
            }
        }
    }

    private void addGroupChecks(List<Task> taskList, String[] oneExistPlusNew, String[] nodeList, boolean db_only) throws TaskFactoryException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (!nativeSys.isUnixSystem()) {
            Trace.out((String)"Not on Unix system, no group checks added.");
            return;
        }
        Trace.out((String)("oneExistPlusNew: '" + VerificationUtil.strArr2List(oneExistPlusNew) + "' nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' db_only: " + db_only));
        String osdbagrpHome = null;
        String localNode = VerificationUtil.getLocalHostName();
        if (db_only) {
            osdbagrpHome = VerificationUtil.getVariableValue("ORACLE_HOME");
            Trace.out((String)("Checking RAC/DB group names using ORACLE_HOME of: '" + osdbagrpHome + "'"));
        }
        ArrayList<String> groupList = new ArrayList<String>();
        try {
            String asmAdminGroup = VerificationUtil.getASMAdminGroup(osdbagrpHome);
            String asmOperGroup = VerificationUtil.getASMOPERGroup(osdbagrpHome);
            String asmDbaGroup = VerificationUtil.getASMDBAGroup(osdbagrpHome);
            String osAsmGroup = VerificationUtil.getOSAsmGroup(osdbagrpHome);
            String osOperGroup = VerificationUtil.getOSOPERGroup(osdbagrpHome);
            String osDbaGroup = VerificationUtil.getOSDBAGroup(osdbagrpHome);
            String osBackupDbaGroup = VerificationUtil.getOSBACKUPDBAGroup(osdbagrpHome);
            String osDgDbaGroup = VerificationUtil.getOSDGDBAGroup(osdbagrpHome);
            String osKmDbaGroup = VerificationUtil.getOSKMDBAGroup(osdbagrpHome);
            if (db_only) {
                this.addGroupToList(groupList, osAsmGroup);
                this.addGroupToList(groupList, osOperGroup);
                this.addGroupToList(groupList, osDbaGroup);
                this.addGroupToList(groupList, osBackupDbaGroup);
                this.addGroupToList(groupList, osDgDbaGroup);
                this.addGroupToList(groupList, osKmDbaGroup);
            } else {
                this.addGroupToList(groupList, asmAdminGroup);
                this.addGroupToList(groupList, asmOperGroup);
                this.addGroupToList(groupList, asmDbaGroup);
            }
            Result result = new Result(localNode);
            String crsUser = VerificationUtil.getCRSUser(localNode, result, true);
            Trace.out((String)("CRS User retrieved = >" + crsUser + "<"));
            TaskGroupExistence groupTask = null;
            for (String grpName : groupList) {
                Trace.out((String)("Adding group existence check for group: >" + grpName + "<"));
                groupTask = new TaskGroupExistence(grpName);
                if (oneExistPlusNew != null) {
                    groupTask.setNodeList(oneExistPlusNew);
                } else {
                    groupTask.setNodeList(nodeList);
                }
                taskList.add(groupTask);
                if (VerificationUtil.isStringGood(crsUser)) {
                    Trace.out((String)("Adding group membership check for CRS user >" + crsUser + "< with group >" + grpName + "<"));
                    TaskGroupMembership grpMemTask = new TaskGroupMembership(crsUser, grpName);
                    grpMemTask.setNodeList(nodeList);
                    taskList.add(grpMemTask);
                    continue;
                }
                Trace.out((String)("CRS user name could not be determined, skipping membership check for crs user in group >" + grpName + "<"));
            }
        }
        catch (CVUException ce) {
            Trace.out((String)("CVUEXCEPTION: " + ce.getMessage()));
            Trace.stackTrace();
        }
    }

    private void addGroupToList(List<String> groupList, String groupName) {
        if (VerificationUtil.isStringGood(groupName) && !groupList.contains(groupName)) {
            groupList.add(groupName.trim());
        }
    }

    static {
        m_isCLImode = false;
        m_isAPImode = false;
        m_isBestPracticemode = false;
        m_pm = null;
        FSEP = System.getProperty("file.separator");
        LSEP = System.getProperty("line.separator");
        try {
            m_pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        m_isCLImode = m_pm.getMode() == ParamManager.OperationMode.MODE_CLI;
        m_isAPImode = m_pm.getMode() == ParamManager.OperationMode.MODE_API;
        m_isBestPracticemode = m_pm.getMode() == ParamManager.OperationMode.MODE_BEST_PRACTICE;
    }
}

